% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sspace_multinom_slow}
\alias{sspace_multinom_slow}
\title{Enumerate the sample space of a multinomial}
\usage{
sspace_multinom_slow(d, n)
}
\arguments{
\item{d}{Dimension}

\item{n}{Size}
}
\value{
A matrix with d columns
}
\description{
We have \eqn{d} mutually exclusive outcomes and \eqn{n} independent trials.
This function enumerates all possible vectors of length \eqn{d} of counts of
each outcome for \eqn{n} trials, i.e., the sample space. The result is output
as a matrix with \eqn{d} columns where each row represents a possible
observation. See \link{sspace_multinom} for a faster implementation using Rust.
}
\examples{
d4s <- sspace_multinom_slow(4, 8)
stopifnot(abs(sum(apply(d4s, 1, dmultinom, prob = rep(.25, 4))) - 1) < 1e-12)

}
