% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geTree.R
\name{testGenerateDerivationTree}
\alias{testGenerateDerivationTree}
\title{Generate, decode, and show \code{times} derivation trees from random 
integer vectors for grammar BNF on the console.}
\usage{
testGenerateDerivationTree(
  times,
  G,
  generateDT = generateDerivationTree,
  verbose = TRUE
)
}
\arguments{
\item{times}{Number of derivation trees which should be generated.}

\item{G}{A grammar object G.}

\item{generateDT}{Function for generating a derivation tree.}

\item{verbose}{Boolean. If TRUE (default) , print decoded derivation tree on console.}
}
\value{
Number of complete derivation trees generated.
}
\description{
Generate, decode, and show \code{times} derivation trees from random 
integer vectors for grammar BNF on the console.
}
\examples{
g<-compileBNF(booleanGrammar())
testGenerateDerivationTree(5, g)
}
\concept{Tests}
