% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfReplicate.R
\name{xegaDfReplicationFactory}
\alias{xegaDfReplicationFactory}
\title{Configure the replication function of a genetic algorithm.}
\usage{
xegaDfReplicationFactory(method = "DE")
}
\arguments{
\item{method}{A string specifying the replication function.}
}
\value{
A replication function for genes.
}
\description{
\code{xegaDfReplicationFactory()} implements the selection
             of a replication method. 

             Current support:

             \enumerate{
             \item "DE" returns \code{xegaDfReplicateGeneDE()}.
             }
}
\examples{
pop10<-lapply(rep(0,10), function(x) xegaDfInitGene(lFxegaDfGene))
epop10<-lapply(pop10, lFxegaDfGene$EvalGene, lF=lFxegaDfGene)
fit10<-unlist(lapply(epop10, function(x) {x$fit}))
Replicate<-xegaDfReplicationFactory("DE")
newgenes2<-Replicate(pop10, fit10, lFxegaDfGene)
}
\seealso{
Other Configuration: 
\code{\link{lFxegaDfGene}},
\code{\link{xegaDfCrossoverFactory}()},
\code{\link{xegaDfGeneMapFactory}()},
\code{\link{xegaDfMutationFactory}()},
\code{\link{xegaDfScaleFactorFactory}()}
}
\concept{Configuration}
