% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPermMutate.R
\name{xegaPermMutateMix}
\alias{xegaPermMutateMix}
\title{Mutation by a random mutation function.}
\usage{
xegaPermMutateMix(gene, lF)
}
\arguments{
\item{gene}{A permutation.}

\item{lF}{Local configuration.}
}
\value{
A permutation.
}
\description{
A mutation function is randomly selected from the following list:
 xegaPermMutateGeneOrderBased, xegaPermMutateGenekInversion,
 xegaPermMutateGene2Opt, xegaPermMutateGenekOptLK, xegaPermMutateGeneGreedy,
 xegaPermMutateGeneBestGreedy.
}
\examples{
gene1<-xegaPermInitGene(lFxegaPermGene)
xegaPermDecodeGene(gene1, lFxegaPermGene)
gene<-xegaPermMutateMix(gene1, lFxegaPermGene)
xegaPermDecodeGene(gene, lFxegaPermGene)
}
\seealso{
Other Mutation: 
\code{\link{xegaPermMutateGene2Opt}()},
\code{\link{xegaPermMutateGeneBestGreedy}()},
\code{\link{xegaPermMutateGeneGreedy}()},
\code{\link{xegaPermMutateGeneOrderBased}()},
\code{\link{xegaPermMutateGenekInversion}()},
\code{\link{xegaPermMutateGenekOptLK}()}
}
\concept{Mutation}
