% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtdml_plr.R
\name{xtdml_plr}
\alias{xtdml_plr}
\title{DML Method for Partially Linear Panel Models}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link{xtdml}.
}
\description{
Routine to estimate partially linear panel regression models with fixed effects within double machine learning.
}
\details{
Consider partially linear panel regression (PLR) model of form

\eqn{ Y_{it} = \theta_0 D_{it} + g_0(x_{it}) + \alpha_i + U_{it}}
\eqn{ D_{it} = m_0(x_{it}) + \gamma_i + V_{it}}.
}
\examples{
# An illustrative example using a regression tree (`rpart`)
library(mlr3)
library(rpart)
library(mlr3tuning)
set.seed(1234)

# Generate simulated dataset
data = make_plpr_data(n_obs = 100, t_per = 5, dim_x = 10, theta = 0.5, rho=0.8)

x_cols  = paste0("X", 1:10)

# Set up DML data environment
obj_xtdml_data = xtdml_data_from_data_frame(data,
                x_cols = x_cols,  y_col = "y", d_cols = "d",
                panel_id = "id",
                time_id = "time",
                approach = "fd-exact")

# Set up DML estimation environment
 learner = lrn("regr.rpart")
 ml_l = learner$clone()
 ml_m = learner$clone()

 obj_xtdml = xtdml_plr$new(obj_xtdml_data,
                           ml_l = ml_l, ml_m = ml_m,
                           score = "orth-PO", n_folds = 3)
# Set up a list of parameter grids
param_grid = list("ml_l" = ps(cp = p_dbl(lower = 0.01, upper = 0.02),
                            maxdepth = p_int(lower = 2, upper = 10)),
                  "ml_m" = ps(cp = p_dbl(lower = 0.01, upper = 0.02),
                            maxdepth = p_int(lower = 2, upper = 10)))

tune_settings = list(n_folds_tune = 3,
                   rsmp_tune = mlr3::rsmp("cv", folds = 3),
                   terminator = mlr3tuning::trm("evals", n_evals = 5),
                   tuner = tnr("grid_search", resolution = 10))

obj_xtdml$tune(param_set = param_grid, tune_settings = tune_settings)
obj_xtdml$fit()

}
\seealso{
Other xtdml: 
\code{\link{xtdml}}
}
\concept{xtdml}
\section{Super class}{
\code{\link[xtdml:xtdml]{xtdml::xtdml}} -> \code{xtdml_plr}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-xtdml_plr-new}{\code{xtdml_plr$new()}}
\item \href{#method-xtdml_plr-set_ml_nuisance_params}{\code{xtdml_plr$set_ml_nuisance_params()}}
\item \href{#method-xtdml_plr-tune}{\code{xtdml_plr$tune()}}
\item \href{#method-xtdml_plr-clone}{\code{xtdml_plr$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xtdml" data-topic="xtdml" data-id="confint"><a href='../../xtdml/html/xtdml.html#method-xtdml-confint'><code>xtdml::xtdml$confint()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xtdml" data-topic="xtdml" data-id="fit"><a href='../../xtdml/html/xtdml.html#method-xtdml-fit'><code>xtdml::xtdml$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xtdml" data-topic="xtdml" data-id="get_panel_info"><a href='../../xtdml/html/xtdml.html#method-xtdml-get_panel_info'><code>xtdml::xtdml$get_panel_info()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xtdml" data-topic="xtdml" data-id="get_params"><a href='../../xtdml/html/xtdml.html#method-xtdml-get_params'><code>xtdml::xtdml$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xtdml" data-topic="xtdml" data-id="learner_names"><a href='../../xtdml/html/xtdml.html#method-xtdml-learner_names'><code>xtdml::xtdml$learner_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xtdml" data-topic="xtdml" data-id="params_names"><a href='../../xtdml/html/xtdml.html#method-xtdml-params_names'><code>xtdml::xtdml$params_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xtdml" data-topic="xtdml" data-id="plot"><a href='../../xtdml/html/xtdml.html#method-xtdml-plot'><code>xtdml::xtdml$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xtdml" data-topic="xtdml" data-id="print"><a href='../../xtdml/html/xtdml.html#method-xtdml-print'><code>xtdml::xtdml$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xtdml" data-topic="xtdml" data-id="split_samples"><a href='../../xtdml/html/xtdml.html#method-xtdml-split_samples'><code>xtdml::xtdml$split_samples()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xtdml" data-topic="xtdml" data-id="summary"><a href='../../xtdml/html/xtdml.html#method-xtdml-summary'><code>xtdml::xtdml$summary()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml_plr-new"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml_plr-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this R6 class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml_plr$new(
  data,
  ml_l,
  ml_m,
  ml_g = NULL,
  n_folds = 5,
  n_rep = 1,
  score = "orth-PO",
  dml_procedure = "dml2",
  draw_sample_splitting = TRUE,
  apply_cross_fitting = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{xtdml_data}) \cr
The \code{xtdml_data} object providing the data and specifying the
variables of the causal model.}

\item{\code{ml_l}}{(\code{\link[mlr3:LearnerRegr]{LearnerRegr}},
\code{\link[mlr3:Learner]{Learner}}, \code{character(1)}) \cr
A learner of the class \code{\link[mlr3:LearnerRegr]{LearnerRegr}}, which is
available from \href{https://mlr3.mlr-org.com/index.html}{mlr3} or its
extension packages \href{https://mlr3learners.mlr-org.com/}{mlr3learners} or
\href{https://mlr3extralearners.mlr-org.com/}{mlr3extralearners}.
Alternatively, a \code{\link[mlr3:Learner]{Learner}} object with public field
\code{task_type = "regr"} can be passed, for example of class
\code{\link[mlr3pipelines:mlr_learners_graph]{GraphLearner}}. The learner can possibly
be passed with specified parameters, for example
\code{lrn("regr.cv_glmnet", s = "lambda.min")}. \cr
\code{ml_l} refers to the nuisance function \eqn{l_0(X) = E[Y|X]}.}

\item{\code{ml_m}}{(\code{\link[mlr3:LearnerRegr]{LearnerRegr}},
\code{\link[mlr3:LearnerClassif]{LearnerClassif}}, \code{\link[mlr3:Learner]{Learner}},
\code{character(1)}) \cr
A learner of the class \code{\link[mlr3:LearnerRegr]{LearnerRegr}}, which is
available from \href{https://mlr3.mlr-org.com/index.html}{mlr3} or its
extension packages \href{https://mlr3learners.mlr-org.com/}{mlr3learners} or
\href{https://mlr3extralearners.mlr-org.com/}{mlr3extralearners}.
For binary treatment variables, an object of the class
\code{\link[mlr3:LearnerClassif]{LearnerClassif}} can be passed, for example
\code{lrn("classif.cv_glmnet", s = "lambda.min")}.
Alternatively, a \code{\link[mlr3:Learner]{Learner}} object with public field
\code{task_type = "regr"} or \code{task_type = "classif"} can be passed,
respectively, for example of class
\code{\link[mlr3pipelines:mlr_learners_graph]{GraphLearner}}. \cr
\code{ml_m} refers to the nuisance function \eqn{m_0(X) = E[D|X]}.}

\item{\code{ml_g}}{(\code{\link[mlr3:LearnerRegr]{LearnerRegr}},
\code{\link[mlr3:Learner]{Learner}}, \code{character(1)}) \cr
A learner of the class \code{\link[mlr3:LearnerRegr]{LearnerRegr}}, which is
available from \href{https://mlr3.mlr-org.com/index.html}{mlr3} or its
extension packages \href{https://mlr3learners.mlr-org.com/}{mlr3learners} or
\href{https://mlr3extralearners.mlr-org.com/}{mlr3extralearners}.
Alternatively, a \code{\link[mlr3:Learner]{Learner}} object with public field
\code{task_type = "regr"} can be passed, for example of class
\code{\link[mlr3pipelines:mlr_learners_graph]{GraphLearner}}. The learner can possibly
be passed with specified parameters, for example
\code{lrn("regr.cv_glmnet", s = "lambda.min")}. \cr
\code{ml_g} refers to the nuisance function \eqn{g_0(X) = E[Y - D\theta_0|X]}.
Note: The learner \code{ml_g} is only required for the score \code{'IV-type'}.
Optionally, it can be specified and estimated for callable scores.}

\item{\code{n_folds}}{(\code{integer(1)})\cr
Number of folds. Default is \code{5}.}

\item{\code{n_rep}}{(\code{integer(1)}) \cr
Number of repetitions for the sample splitting. Default is \code{1}.}

\item{\code{score}}{(\code{character(1)}) \cr
A \code{character(1)} (\code{"orth-PO"} or \code{"orth-IV"}).
\code{"orth-PO"} is Neyman-orthogonal score with the partialling-out formula.
\code{"orth-IV"} is Neyman-orthogonal score with the IV-type formula.
Default is \code{"orth-PO"}.}

\item{\code{dml_procedure}}{(\code{character(1)}) \cr
A \code{character(1)} (\code{"dml1"} or \code{"dml2"}) specifying the double machine
learning algorithm. Default is \code{"dml2"}.}

\item{\code{draw_sample_splitting}}{(\code{logical(1)}) \cr
Indicates whether the sample splitting should be drawn during
initialization of the object. Default is \code{TRUE}.}

\item{\code{apply_cross_fitting}}{(\code{logical(1)}) \cr
Indicates whether cross-fitting should be applied. Default is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml_plr-set_ml_nuisance_params"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml_plr-set_ml_nuisance_params}{}}}
\subsection{Method \code{set_ml_nuisance_params()}}{
Sets hyperparameters for the nuisance models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml_plr$set_ml_nuisance_params(
  learner = NULL,
  treat_var = NULL,
  params,
  set_fold_specific = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{(\code{character(1)}) \cr
The nuisance model/learner (see method \code{params_names}).}

\item{\code{treat_var}}{(\code{character(1)}) \cr
The treatment varaible (hyperparameters can be set treatment-variable
specific).}

\item{\code{params}}{(named \code{list()}) \cr
A named \code{list()} with estimator parameters. Parameters are used for all
folds by default. Alternatively, parameters can be passed in a
fold-specific way if option  \code{fold_specific}is \code{TRUE}. In this case, the
outer list needs to be of length \code{n_rep} and the inner list of length
\code{n_folds}.}

\item{\code{set_fold_specific}}{(\code{logical(1)}) \cr
Indicates if the parameters passed in \code{params_theta} should be passed in
fold-specific way. Default is \code{FALSE}. If \code{TRUE}, the outer list needs
to be of length \code{n_rep} and the inner list of length \code{n_folds}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml_plr-tune"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml_plr-tune}{}}}
\subsection{Method \code{tune()}}{
Conducts hyperparameter-tuning.

The hyperparameter-tuning is performed using the tuning methods provided
in the \href{https://mlr3tuning.mlr-org.com/}{mlr3tuning} package. For more
information on tuning in \href{https://mlr3.mlr-org.com/}{mlr3}, we refer to
the section on parameter tuning in the
\href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html}{mlr3 book}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml_plr$tune(
  param_set,
  tune_settings = list(n_folds_tune = 5, rsmp_tune = mlr3::rsmp("cv", folds = 5), measure
    = NULL, terminator = mlr3tuning::trm("evals", n_evals = 20), algorithm =
    mlr3tuning::tnr("grid_search"), resolution = 5),
  tune_on_folds = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(named \code{list()}) \cr
A named \code{list} with a parameter grid for each nuisance model/learner
(see method \code{learner_names()}). The parameter grid must be an object of
class \link[paradox:ParamSet]{ParamSet}.}

\item{\code{tune_settings}}{(named \code{list()}) \cr
A named \code{list()} with arguments passed to the hyperparameter-tuning with
\href{https://mlr3tuning.mlr-org.com/}{mlr3tuning} to set up
a tuning instance using \code{mlr3tuning::TuningInstanceBatchSingleCrit$new()} (see the mlr3tuning package).

\code{tune_settings} has entries
\itemize{
\item \code{terminator} (\link[bbotk:Terminator]{Terminator}) \cr
A \link[bbotk:Terminator]{Terminator} object. Specification of \code{terminator}
is required to perform tuning.
\item \code{algorithm} (\link[mlr3tuning:Tuner]{Tuner} or \code{character(1)}) \cr
A \link[mlr3tuning:Tuner]{Tuner} object (recommended) or key passed to the
respective dictionary to specify the tuning algorithm used in
\link[mlr3tuning:tnr]{tnr()}. \code{algorithm} is passed as an argument to
\link[mlr3tuning:tnr]{tnr()}. If \code{algorithm} is not specified by the users,
default is set to \code{"grid_search"}. If set to \code{"grid_search"}, then
additional argument \code{"resolution"} is required.
\item \code{rsmp_tune} (\link[mlr3:Resampling]{Resampling} or \code{character(1)})\cr
A \link[mlr3:Resampling]{Resampling} object (recommended) or option passed
to \link[mlr3:mlr_sugar]{rsmp()} to initialize a
\link[mlr3:Resampling]{Resampling} for parameter tuning in \code{mlr3}.
If not specified by the user, default is set to \code{"cv"}
(cross-validation).
\item \code{n_folds_tune} (\code{integer(1)}, optional) \cr
If \code{rsmp_tune = "cv"}, number of folds used for cross-validation.
If not specified by the user, default is set to \code{5}.
\item \code{measure} (\code{NULL}, named \code{list()}, optional) \cr
Named list containing the measures used for parameter tuning. Entries in
list must either be \link[mlr3:Measure]{Measure} objects or keys to be
passed to passed to \link[mlr3:mlr_sugar]{msr()}. The names of the entries must
match the learner names (see method \code{learner_names()}). If set to \code{NULL},
default measures are used, i.e., \code{"regr.mse"} for continuous outcome
variables and \code{"classif.ce"} for binary outcomes.
\item \code{resolution} (\code{character(1)}) \cr The key passed to the respective
dictionary to specify  the tuning algorithm used in
\link[mlr3tuning:tnr]{tnr()}. \code{resolution} is passed as an argument to
\link[mlr3tuning:tnr]{tnr()}.
}}

\item{\code{tune_on_folds}}{(\code{logical(1)}) \cr
Indicates whether the tuning should be done fold-specific or globally.
Default is \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml_plr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml_plr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml_plr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
