% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module2_estimate_3pl.R
\name{estimate_3pl}
\alias{estimate_3pl}
\alias{model_3pl_eap_scoring}
\alias{model_3pl_map_scoring}
\alias{model_3pl_dv_Pt}
\alias{model_3pl_dv_Pa}
\alias{model_3pl_dv_Pb}
\alias{model_3pl_dv_Pc}
\alias{model_3pl_dv_jmle}
\alias{model_3pl_estimate_jmle}
\alias{model_3pl_dv_mmle}
\alias{model_3pl_estimate_mmle}
\alias{model_3pl_fitplot}
\title{Estimate 3-parameter-logistic model}
\usage{
model_3pl_eap_scoring(u, a, b, c, D = 1.702, prior = c(0, 1),
  bound = c(-3, 3))

model_3pl_map_scoring(u, a, b, c, D = 1.702, prior = c(0, 1),
  bound = c(-3, 3), nr_iter = 30, nr_conv = 0.001)

model_3pl_dv_Pt(t, a, b, c, D)

model_3pl_dv_Pa(t, a, b, c, D)

model_3pl_dv_Pb(t, a, b, c, D)

model_3pl_dv_Pc(t, a, b, c, D)

model_3pl_dv_jmle(dv, u)

model_3pl_estimate_jmle(u, t = NA, a = NA, b = NA, c = NA,
  D = 1.702, iter = 100, conv = 1, nr_iter = 10, nr_conv = 0.001,
  scale = c(0, 1), bounds_t = c(-3, 3), bounds_a = c(0.01, 2),
  bounds_b = c(-3, 3), bounds_c = c(0, 0.25), priors = list(t = c(0,
  1), a = c(-0.1, 0.2), b = c(0, 1), c = c(4, 20)), decay = 1,
  debug = FALSE, true_params = NULL)

model_3pl_dv_mmle(pdv_fn, u, quad, a, b, c, D)

model_3pl_estimate_mmle(u, t = NA, a = NA, b = NA, c = NA,
  D = 1.702, iter = 100, conv = 1, nr_iter = 10, nr_conv = 0.001,
  bounds_t = c(-3, 3), bounds_a = c(0.01, 2), bounds_b = c(-3, 3),
  bounds_c = c(0, 0.25), priors = list(t = c(0, 1), a = c(-0.1, 0.2), b
  = c(0, 1), c = c(4, 20)), decay = 1, quad_degree = "11",
  scoring = c("eap", "map"), debug = FALSE, true_params = NULL)

model_3pl_fitplot(u, t, a, b, c, D = 1.702, index = NULL,
  intervals = seq(-3, 3, 0.5), show_points = TRUE)
}
\arguments{
\item{u}{observed response matrix, 2d matrix}

\item{a}{discrimination parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{b}{difficulty parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{c}{pseudo-guessing parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{D}{the scaling constant, 1.702 by default}

\item{prior}{the prior distribution}

\item{nr_iter}{the maximum iterations of newton-raphson}

\item{nr_conv}{the convegence criterion for newton-raphson}

\item{t}{ability parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{iter}{the maximum iterations}

\item{conv}{the convergence criterion of the -2 log-likelihood}

\item{scale}{the meand and SD of the theta scale, N(0, 1) for JMLE by default}

\item{bounds_t}{bounds of ability parameters}

\item{bounds_a}{bounds of discrimination parameters}

\item{bounds_b}{bounds of difficulty parameters}

\item{bounds_c}{bounds of guessing parameters}

\item{priors}{a list of prior distributions}

\item{decay}{decay rate}

\item{debug}{TRUE to print debuggin information}

\item{true_params}{a list of true parameters for evaluating the estimation accuracy}

\item{pdv_fn}{the function to compute derivatives of P w.r.t the estimating parameters}

\item{quad_degree}{the number of quadrature points}

\item{scoring}{the scoring method: 'eap' or 'map'}

\item{index}{the indices of items being plotted}

\item{intervals}{intervals on the x-axis}

\item{show_points}{TRUE to show points}
}
\description{
Estimate the 3PL model using the maximum likelihood estimation

\code{model_3pl_eap_scoring} scores response vectors using the EAP method

\code{model_3pl_map_scoring} scores response vectors using the MAP method

\code{model_3pl_dv_jmle} calculates the first and second derivatives for
the joint maximum likelihood estimation

\code{model_3pl_estimate_jmle} estimates the parameters using the 
joint maximum likelihood estimation (JMLE) method

\code{model_3pl_dv_mmle} calculates the first and second derivatives for
the marginal maximum likelihood estimation

\code{model_3pl_estimate_mmle} estimates the parameters using the 
marginal maximum likelihood estimation (MMLE) method
}
\examples{
with(model_3pl_gendata(10, 40), cbind(true=t, est=model_3pl_eap_scoring(u, a, b, c)$t))
with(model_3pl_gendata(10, 40), cbind(true=t, est=model_3pl_map_scoring(u, a, b, c)$t))
\dontrun{
# generate data
x <- model_3pl_gendata(2000, 40)
# free estimation
y <- model_3pl_estimate_jmle(x$u, true_params=x)
# fix c-parameters
y <- model_3pl_estimate_jmle(x$u, c=0, true_params=x)
# no priors
y <- model_3pl_estimate_jmle(x$u, priors=NULL, iter=30, debug=T)
}
\dontrun{
# generate data
x <- model_3pl_gendata(2000, 40)
# free estimation
y <- model_3pl_estimate_mmle(x$u, true_params=x)
# fix c-parameters
y <- model_3pl_estimate_mmle(x$u, c=0, true_params=x)
# no priors
y <- model_3pl_estimate_mmle(x$u, priors=NULL, iter=30, debug=T)
}
with(model_3pl_gendata(1000, 20), model_3pl_fitplot(u, t, a, b, c, index=c(1, 3, 5)))
}
\keyword{internal}
