% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piratepal_function.R
\name{piratepal}
\alias{piratepal}
\title{piratepal}
\usage{
piratepal(
  palette = "all",
  trans = 0,
  mix.col = "white",
  mix.p = 0,
  plot.result = FALSE,
  length.out = NULL
)
}
\arguments{
\item{palette}{A string defining the color palette to use (see examples). To use a random palette, use "random". To plot all palettes, use "all". To see all palette names, use "names"}

\item{trans}{A number in the interval [0, 1] indicating how transparent to make the colors. A value of 0 means no transparency and a value of 1 means completely transparency.}

\item{mix.col}{string. An optional string representing a color to mix all colors in the palette with.}

\item{mix.p}{numeric. A number in the interval [0, 1] indicating how much to mix the palette colors with the color in \code{mix.col}}

\item{plot.result}{A logical value indicating whether or not to display the colors.}

\item{length.out}{An integer indicating how many colors to return. If length.out is larger than the number of colors in the palette, colors will be repeated.}
}
\description{
This function provides a number of color palettes
}
\examples{


# Check out the vignette for a full guide

vignette("piratepal", package = "yarrr")

# Show all palettes

piratepal(palette = "all")

# Show some palettes

piratepal(palette = "basel", trans = .5, plot.result = TRUE)


# Using a palette in a scatterplot

nemo.cols <- piratepal(palette = "nemo", trans = .5)

set.seed(100) # For reproducibility
x <- rnorm(100)
y <- x + rnorm(100)

plot(
  x = x, y = y, col = nemo.cols,
  pch = 16,
  cex = runif(100, min = 0, max = 2),
  main = "piratepal('nemo', trans = .5)"
)

}
\keyword{colors}
