% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_all_clades}
\alias{get_all_clades}
\title{Extract all clades present in the lineages}
\usage{
get_all_clades(lineage, simplify = TRUE)
}
\arguments{
\item{lineage}{string. Vector of lineages.}

\item{simplify}{logical. Should the output be a vector or a dataframe?}
}
\value{
The clades present in the lineage. Vector of ordered strings
or data.frame.
}
\description{
Extract all clades present in the lineages
}
\details{
If a clade correspond to different ranks (e.g. Actinobacteria
is both a phylum and a clade), it will be displayed only one time when
\code{simplify} is set to \code{TRUE}. It is also the case for different
clades with same name and same rank when \code{simplify} is set to
\code{FALSE}.
}
\examples{
lineage1 <- "k__Bacteria|p__Verrucomicrobia|c__Verrucomicrobiae"
lineage2 <- "k__Bacteria|p__Firmicutes|c__Clostridia"
lineage3 <- "k__Bacteria|p__Actinobacteria|c__Actinobacteria"
get_all_clades(c(lineage1, lineage2, lineage3))
get_all_clades(c(lineage1, lineage2, lineage3), simplify = FALSE)
}
