% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getlayout.R
\name{get_layout}
\alias{get_layout}
\title{Compute the layout of the zen plot}
\usage{
get_layout(
  turns,
  n2dplots,
  first1d = TRUE,
  last1d = TRUE,
  width1d = 1,
  width2d = 10
)
}
\arguments{
\item{turns}{turns (character vector consisting if "u", "d", "l", "r")}

\item{n2dplots}{the number of 2d plots (faces of the hypercube to be laid out)}

\item{first1d}{logical indicating whether the first 1d plot should be plotted}

\item{last1d}{logical indicating whether the last 1d plot should be plotted}

\item{width1d}{width of 1d plots}

\item{width2d}{width of 2d plots}
}
\value{
list containing
        1) the plot orientations (c("h", "s", "v", "s", ...))
        2) the plot dimensions (1d plot, 2d plot, 1d plot, ...)
        3) the variable numbers plotted (an (nPlots, 2)-matrix)
        4) the total width of the layout
        5) the total height of the layout
        6) coordinates of the bounding boxes
}
\description{
Compute the layout of the zen plot
}
\author{
Marius Hofert and Wayne Oldford
}
