% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbosity_level.R
\name{verbosity_level}
\alias{verbosity_level}
\title{Verbosity level to control package behavior}
\description{
In zephyr we define a central verbosity level to control the amount of
messages the user receives when using zephyr and other packages
in the ecosystem.

Verbosity level can be any of the four values below:
\enumerate{
\item \code{quiet}: No messages are displayed.
\item \code{minimal}: Only essential messages are displayed.
\item \code{verbose} (\emph{default}): More informative messages are displayed.
\item \code{debug}: Detailed messages for debugging are displayed.
}

See \code{\link[=use_zephyr]{use_zephyr()}} and \link{msg} for how to implement the use of verbosity levels
in your package and its functions.

Verbosity level is a special kind of option that can be scoped both for a
specific package and and globally for the ecosystem
(assigned to the zephyr package).
It can be set using either R \code{options()} or environment variables.

Verbosity level is retrieved using the \code{\link[=get_verbosity_level]{get_verbosity_level()}} function.
Since the level can have multiples scopes, the following hierarchy is used:
\enumerate{
\item Package specific option: \verb{\{pkgname\}.verbosity_level}
\item Package specific environment variable: \verb{R_\{PKGNAME\}_VERBOSITY_LEVEL}
\item Ecosystem wide option: \code{zephyr.verbosity_level}
\item Ecosystem wide environment variable (\code{R_ZEPHYR_VERBOSITY_LEVEL})
\item Default value specified in zephyr (\code{verbose}, see above).
}

In order to see all registered verbosity levels across scopes call
\code{\link[=get_all_verbosity_levels]{get_all_verbosity_levels()}}.
}
\examples{
get_verbosity_level("zephyr")
get_all_verbosity_levels()
}
