% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_utils.R
\name{curly_arg}
\alias{curly_arg}
\title{Process curly parameters}
\usage{
curly_arg(param)
}
\arguments{
\item{param}{The parameter to process as a curly param.}
}
\description{
Curly parameters are processed using NSE, unless they are encapsulated in
curlies \code{{}}, which optionally triggers standard evaluation. This function
is only intended to be used inside another function, and it is used in
a very similar way to \code{match.arg()}. The examples are very useful ...
}
\examples{
# Not run automatically because curly_arg() is private
\dontrun{
  # Usage of curly_arg() compared with match.arg()
  curly_demo <- function(x, y = c("yes", "no")) {
    x <- zfit:::curly_arg(x)
    y <- match.arg(y)
    x
  }

  myparam  <- "a string"
  myvector <- c("string 1", "string 2")

  curly_demo(a_symbol)       # NSE ON
  curly_demo("a string")     # NSE disabled with "" for constant strins
  curly_demo({"curly-wrap"}) # NSE disabled with {}
  curly_demo(c("a","b"))     # NSE ON, usually not wanted, quoting preferred
  curly_demo({c("a","b")})   # NSE disabled with {}, allowing vectors
  curly_demo(myparam)        # NSE ON, even if a value exists for myparam
  curly_demo("myparam")      # NSE disabled, result is a string constant
  curly_demo({myparam})      # NSE disabled, value of myparam propagates
  curly_demo({myvector})     # NSE disabled, value of myvector propagates
}

}
\keyword{internal}
