% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_post.R
\name{zz_post}
\alias{zz_post}
\title{Post file to Zamzar endpoint}
\usage{
zz_post(
  file = NULL,
  extension = NULL,
  usr = NULL,
  prod = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{file}{The path to the file you want to convert.}

\item{extension}{The file type you want to convert to. E.g., `png`.}

\item{usr}{The username/API key you are using. If not set, the function
will check if a key exists as a `ZAMZAR_USR` variable  in `.Renviron` and use that.    

See: \url{https://developers.zamzar.com/user}}

\item{prod}{Boolean deciding whether to use production or development endpoint.
Defaults to `FALSE`.}

\item{verbose}{Boolean deciding whether or not verbose status messages
should be returned. Defaults to `FALSE`.}
}
\value{
A status message indicating either success or failure.
}
\description{
Per default `zz_post()` assumes that you're doing development, thus using a 
development endpoint. Set parameter `prod` to `TRUE` to change this behavior.
}
\details{
On differences between endpoints, see: \url{https://developers.zamzar.com/docs#section-Next_steps} and  \url{https://developers.zamzar.com/docs#section-Rate_Limits}

Please note that a Zamzar key passed as argument to `usr` takes precedence over a
Zamzar key extracted from an `.Renviron`.
}
\examples{
\dontrun{
# Per default zz_post uses the development endpoint.
zz_post(file = "avatar.emf", extension = "png")

# Setting prod parameter to FALSE is the same as above.
zz_post(file = "avatar.emf", extension = "png", prod = FALSE)

# You need to flip prod to TRUE if you want to use the production endpoint.
zz_post(file = "avatar.emf", extension = "png", prod = TRUE)

# Remember you can always pass a Zamzar key to the usr parameter if you don't
# want to use an .Renviron file.
zz_post(file = "avatar.emf", usr = "key", extension = "png", prod = TRUE)
 
}
}
\seealso{
\code{\link{zz_format}} for a list of formats you can convert to.
}
