#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

#LCA (Latent Class Analysis) - model klas ukrytych
#Estymacja modelu z wykorzystaniem pakietu poLCA
#Dane symulacyjne - wartoci nominalnych (dychotomicznych) zmiennych obserwowanych 1 lub 2
#Cel analizy: oszacowanie prawdopodobiestw wyboru opcji 1 i 2 w 3 klasach
library(poLCA)
options(OutDec=",")
#Generowanie danych, 6 zmiennych obserwowanych dychotomicznych Y1-Y6
set.seed(36)
probs<-list(matrix(c(0.1,0.9, 0.6,0.4, 0.9,0.1),ncol=2,byrow=TRUE), 
            matrix(c(0.2,0.8, 0.5,0.5, 0.9,0.1),ncol=2,byrow=TRUE), 
            matrix(c(0.2,0.8, 0.4,0.6, 0.9,0.1),ncol=2,byrow=TRUE), 
            matrix(c(0.2,0.8, 0.5,0.5, 0.8,0.2),ncol=2,byrow=TRUE), 
            matrix(c(0.2,0.8, 0.4,0.6, 0.9,0.1),ncol=2,byrow=TRUE), 
            matrix(c(0.2,0.8, 0.5,0.5, 0.8,0.2),ncol=2,byrow=TRUE))
danesym1<-poLCA.simdata(N=100,probs,ndv=6)
print(danesym1$dat[1:20,])
#Model - zmienne obserwowane Y1-Y6, bez zmiennych towarzyszcych, 3 klasy
model1<-cbind(Y1,Y2,Y3,Y4,Y5,Y6)~1
lc3<-poLCA(model1,danesym1$dat,nclass=3,nrep=1,verbose=FALSE)
probs.start<-poLCA.reorder(lc3$probs.start,order(lc3$P,decreasing=FALSE))
lc3<-poLCA(model1,danesym1$dat,nclass=3,nrep=1,probs.start=probs.start,graph=TRUE)
#print(lc3$probs)
#prawdopodobiestwa dla Y=1, wykres 1
p1<-cbind(lc3$probs$Y1[,1],lc3$probs$Y2[,1],lc3$probs$Y3[,1],lc3$probs$Y4[,1],lc3$probs$Y5[,1],lc3$probs$Y6[,1])
windows(width=8,height=4,pointsize=8)	#okno graficzne
par(mfrow=c(1,2),las=1)				#2 wykresy
plot(c(1,6),c(0,1),xlab="Zmienne obserwowane (Y1-Y6)",ylab="Prawdopodobiestwa dla Y=1",type="n",col=1,yaxt="n",xaxt="n")
axis(1,at=seq(1,6,1),labels=seq(1,6,1),las=1)
axis(2,at=seq(0,1,0.2),labels=seq(0,1,.2),las=1)
for(k in 1:3){lines(c(1:6),p1[k,],col=k,lty=k)}
lines(c(4.0,4.5),c(0.4,0.4),col=1,lty=1)
text(5.0,0.4,"klasa 1")
lines(c(4.0,4.5),c(0.35,0.35),col=2,lty=2)
text(5.0,0.35,"klasa 2")
lines(c(4.0,4.5),c(0.3,0.3),col=3,lty=3)
text(5.0,0.3,"klasa 3")
#prawdopodobiestwa dla Y=2, wykres 2
p2<-cbind(lc3$probs$Y1[,2],lc3$probs$Y2[,2],lc3$probs$Y3[,2],lc3$probs$Y4[,2],lc3$probs$Y5[,2],lc3$probs$Y6[,2])
plot(c(1,6),c(0,1),xlab="Zmienne obserwowane (Y1-Y6)",ylab="Prawdopodobiestwa dla Y=2",type="n",col=1,yaxt="n",xaxt="n")
axis(1,at=seq(1,6,1),labels=seq(1,6,1),las=1)
axis(2,at=seq(0,1,.2),labels=seq(0,1,.2),las=1)
for(k in 1:3){lines(c(1:6),p2[k,],col=k,lty=k)}
lines(c(4.0,4.5),c(0.6,0.6),col=1,lty=1)
text(5.0,0.6,"klasa 1")
lines(c(4.0,4.5),c(0.55,0.55),col=2,lty=2)
text(5.0,0.55,"klasa 2")
lines(c(4.0,4.5),c(0.5,0.5),col=3,lty=3)
text(5.0,0.5,"klasa 3")
