# diysrch.tcl
# search functions for diyhelp

# GetKwFileList
# Arguments:
#	keyword
#	mask
# Return value:
#	a list of filenames containing the keyword

proc GetKwFileList { keyword mask } {
 set filelist [ list ]
 # calling grep directly bombs with "no such file" even if it's there
 set greperr [ catch { set filelist [ exec hidegrep $keyword $mask ] } ]
 # puts "grep error = $greperr"
 return $filelist
}

# BuildFileList
# Arguments:
#	the keyword that is being searched
#	the directory name to search (optional)
#	flag indicating whether the current directory is to be searched
#	the file list to be built
# Return value:
#	a list of filenames that contain the keyword
# Searches directories recursively from the current directory for files 
# that contain the keyword.  The search may be constrained in two ways:
# mask - only filenames that match "mask" will be searched
# searchdir - only directories that match "searchdir" exactly will be searched

proc BuildFileList { keyword searchdir procflag kwfilelist } {

 set path [ pwd ]
 # don't use a file mask in this version
 set mask *
 # If the flag is set, process this directory
 if { $procflag } {
  set filelist [ GetKwFileList $keyword $mask ]
  # puts "file list for [ pwd ] is:\n $filelist"
  foreach filein $filelist {
   # don't include the 00Index.html files
   if { ! [ string match [ string range $filein 0 1 ] 00 ] } {
    # get the directory/filename and append filename as dummy label
    lappend kwfilelist [ list [ join [ list $path $filein ] / ] $filein ]
   }
  }
  # puts "kwfilelist is now:\n $kwfilelist"
  # clear the flag
  set procflag 0
 }
 set dirlist [ GetFileList "*" ]
 foreach dirin $dirlist {
  # is it a directory?
  if { [ file isdirectory $dirin ] } {
   # is there an explicit directory name to search?
   if { [ string length $searchdir ] } {
    # check if this directory name matches searchdir
    if { [ string match $dirin $searchdir ] } {
     set procflag 1
    }
   } else {
    set procflag 1
   }
   # change to the next subdirectory and call yourself.
   cd [ join [ list $path $dirin ] "/" ]
   set kwfilelist\
    [ BuildFileList $keyword $searchdir $procflag $kwfilelist ]
   # when finished, change back to the previous (higher) path
   cd $path
   # and clear that flag
   set procflag 0
  }
 }
 return $kwfilelist
}
