% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OHPL-datalist.R
\docType{data}
\name{soil}
\alias{soil}
\title{The soil dataset}
\usage{
data(soil)
}
\description{
The soil dataset contains 108 sample measurements from the
wavelength range of 400–2500 nm (visible and near infrared spectrum)
published by Rinnan et al.
}
\examples{
data("soil")

X <- soil$x
y <- soil$som
n <- nrow(soil$x)

set.seed(1001)
samp.idx <- sample(1L:n, round(n * 0.7))
X.cal <- X[samp.idx, ]
y.cal <- y[samp.idx]
X.test <- X[-samp.idx, ]
y.test <- y[-samp.idx]
}
\references{
Rinnan, R., & Rinnan, A. (2007). Application of near infrared
reflectance (NIR) and fluorescence spectroscopy to analysis of
microbiological and chemical properties of arctic soil.
\emph{Soil biology and Biochemistry}, 39(7), 1664--1673.
}
