###########################################################################/**
# @RdocDefault findSourceTraceback
# 
# @title "Finds all 'srcfile' objects generated by source() in all call frames"
# 
# @synopsis
# 
# \description{
#   @get "title".  This makes it possible to find out which files are 
#   currently scripted by @see "base::source".
# }
# 
# \arguments{
#  \item{...}{Not used.}
# } 
#
# \value{
#   Returns a named list of objects of class 'srcfile'.
#   The names of the list entries corresponds to the 'filename'
#   value of each corresponding 'srcfile' object.
#   The returned list is empty if @see "base::source" was not called.
# }
# 
# @author
# 
# @keyword IO
# @keyword programming
#*/###########################################################################
setMethodS3("findSourceTraceback", "default", function(...) {
  # Identify the environment/frame of interest by making sure
  # it at least contains all the arguments of source().
  argsToFind <- names(formals(base::source));

  # Scan the call frames/environments backwards...
  srcfileList <- list();
  for (ff in sys.nframe():0) {
    env <- sys.frame(ff);

    # Does the environment look like a source() environment?
    exist <- sapply(argsToFind, FUN=exists, envir=env);
    if (!all(exist)) {
      # Nope, then skip to the next one
      next;
    }
    # Identify the source file
    srcfile <- get("srcfile", envir=env);
    if (!is.null(srcfile)) {
      if (!is.function(srcfile)) {
        srcfileList <- c(srcfileList, list(srcfile));
      }
    }
  } # for (ff ...)

  # Drop any duplicates
#  srcfileList <- unique(srcfileList);

  # Extract the pathnames to the files called
  pathnames <- sapply(srcfileList, FUN=function(srcfile) {
    if (inherits(srcfile, "srcfile")) {
      pathname <- srcfile$filename;
    } else if (is.environment(srcfile)) {
      pathname <- get("filename", envir=env);
    } else {
      throw("Unknown class of 'srcfile': ", class(srcfile)[1]);
    }

    pathname;
  });
  names(srcfileList) <- pathnames;

  srcfileList;
}) # findSourceTraceback()

############################################################################
# HISTORY:
# 2010-03-02
# o BUG FIX: findSourceTraceback() stopped working; probably due to some
#   recent updates in base::source().
# 2009-10-20
# o Created.
############################################################################
