% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-factor.R
\name{opts_factor}
\alias{opts_factor}
\title{Constructive options for class 'factor'}
\usage{
opts_factor(
  constructor = c("factor", "as_factor", "new_factor", "next", "atomic"),
  ...
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the environment, see Details section.}

\item{...}{Should not be used. Forces passing arguments by name.}
}
\value{
An object of class <constructive_options/constructive_options_factor>
}
\description{
These options will be used on objects of class 'factor'.
}
\details{
Depending on \code{constructor}, we construct the environment as follows:
\itemize{
\item \code{"factor"} (default): Build the object using \code{factor()}, levels won't
be defined explicitly if they are in alphabetical order (locale dependent!)
\item \code{"as_factor"} : Build the object using \code{forcats::as_factor()} whenever
possible, i.e. when levels are defined in order of appearance in the vector. Otherwise falls back to \code{"factor"} constructor.
\item \code{"new_factor"} : Build the object using \code{vctrs::new_factor()}. Levels are
always defined explicitly.
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried.
\item \code{"atomic"} : We define as an atomic vector and repair attributes.
}
}
