% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_break_down.R
\name{plot.break_down}
\alias{plot.break_down}
\title{Plot Generic for Break Down Objects}
\usage{
\method{plot}{break_down}(
  x,
  ...,
  baseline = NA,
  max_features = 10,
  min_max = NA,
  vcolors = DALEX::colors_breakdown_drwhy(),
  digits = 3,
  rounding_function = round,
  add_contributions = TRUE,
  shift_contributions = 0.05,
  plot_distributions = FALSE,
  vnames = NULL,
  title = "Break Down profile",
  subtitle = "",
  max_vars = NULL
)
}
\arguments{
\item{x}{an explanation created with \code{\link{break_down}}}

\item{...}{other parameters.}

\item{baseline}{if numeric then veritical line starts in \code{baseline}.}

\item{max_features}{maximal number of features to be included in the plot. default value is \code{10}.}

\item{min_max}{a range of OX axis. By default \code{NA}, therefore it will be extracted from the contributions of \code{x}. But it can be set to some constants, useful if these plots are to be used for comparisons.}

\item{vcolors}{If \code{NA} (default), DrWhy colors are used.}

\item{digits}{number of decimal places (\code{\link{round}}) or significant digits (\code{\link{signif}}) to be used.
See the \code{rounding_function} argument.}

\item{rounding_function}{a function to be used for rounding numbers.
This should be \code{\link{signif}} which keeps a specified number of significant digits or \code{\link{round}} (which is default) to have the same precision for all components.}

\item{add_contributions}{if \code{TRUE}, variable contributions will be added to the plot}

\item{shift_contributions}{number describing how much labels should be shifted to the right, as a fraction of range. By default equal to \code{0.05}.}

\item{plot_distributions}{if \code{TRUE} then distributions of conditional propotions will be plotted. This requires \code{keep_distributions=TRUE} in the
\code{\link{break_down}}, \code{\link{local_attributions}}, or \code{\link{local_interactions}}.}

\item{vnames}{a character vector, if specified then will be used as labels on OY axis. By default NULL}

\item{title}{a character. Plot title. By default \code{"Break Down profile"}.}

\item{subtitle}{a character. Plot subtitle. By default \code{""}.}

\item{max_vars}{alias for the \code{max_features} parameter.}
}
\value{
a \code{ggplot2} object.
}
\description{
Displays a waterfall break down plot for objects of \code{break_down} class.
}
\examples{
library("DALEX")
library("iBreakDown")
set.seed(1313)
model_titanic_glm <- glm(survived ~ gender + age + fare,
                       data = titanic_imputed, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic_imputed,
                           y = titanic_imputed$survived,
                           label = "glm")

bd_glm <- break_down(explain_titanic_glm, titanic_imputed[1, ])
bd_glm
plot(bd_glm, max_features = 3)
plot(bd_glm, max_features = 3,
     vnames = c("average","+ male","+ young","+ cheap ticket", "+ other factors", "final"))

\dontrun{
## Not run:
library("randomForest")
set.seed(1313)
# example with interaction
# classification for HR data
model <- randomForest(status ~ . , data = HR)
new_observation <- HR_test[1,]

explainer_rf <- explain(model,
                        data = HR[1:1000,1:5])

bd_rf <- local_attributions(explainer_rf,
                           new_observation)
bd_rf
plot(bd_rf)
plot(bd_rf, baseline = 0)
plot(bd_rf, min_max = c(0,1))

bd_rf <- local_attributions(explainer_rf,
                           new_observation,
                           keep_distributions = TRUE)
bd_rf
plot(bd_rf, plot_distributions = TRUE)

bd_rf <- local_interactions(explainer_rf,
                 new_observation,
                 keep_distributions = TRUE)

bd_rf
plot(bd_rf)
plot(bd_rf, plot_distributions = TRUE)

# example for regression - apartment prices
# here we do not have intreactions
model <- randomForest(m2.price ~ . , data = apartments)
explainer_rf <- explain(model,
                        data = apartments_test[1:1000,2:6],
                        y = apartments_test$m2.price[1:1000])

bd_rf <- local_attributions(explainer_rf,
                           apartments_test[1,])
bd_rf
plot(bd_rf, digits = 1)
plot(bd_rf, digits = 1, baseline = 0)

bd_rf <- local_attributions(explainer_rf,
                           apartments_test[1,],
                           keep_distributions = TRUE)
plot(bd_rf, plot_distributions = TRUE)

bd_rf <- local_interactions(explainer_rf,
                 new_observation = apartments_test[1,],
                 keep_distributions = TRUE)

bd_rf
plot(bd_rf)
plot(bd_rf, plot_distributions = TRUE)
}
}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema}
}
