% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestcox.R
\name{TableSubgroupCox}
\alias{TableSubgroupCox}
\title{TableSubgroupCox: Sub-group analysis table for Cox/svycox model.}
\usage{
TableSubgroupCox(
  formula,
  var_subgroup = NULL,
  var_cov = NULL,
  data,
  time_eventrate = 3 * 365,
  decimal.hr = 2,
  decimal.percent = 1,
  decimal.pvalue = 3,
  cluster = NULL
)
}
\arguments{
\item{formula}{formula with survival analysis.}

\item{var_subgroup}{1 sub-group variable for analysis, Default: NULL}

\item{var_cov}{Variables for additional adjust, Default: NULL}

\item{data}{Data or svydesign in survey package.}

\item{time_eventrate}{Time for kaplan-meier based event rate calculation, Default = 365 * 3}

\item{decimal.hr}{Decimal for hazard ratio, Default: 2}

\item{decimal.percent}{Decimal for percent, Default: 1}

\item{decimal.pvalue}{Decimal for pvalue, Default: 3}

\item{cluster}{Cluster variable for coxph, Default: NULL}
}
\value{
Sub-group analysis table.
}
\description{
Sub-group analysis table for Cox/svycox model.
}
\details{
This result is used to make forestplot.
}
\examples{
library(survival)
library(dplyr)
lung \%>\%
  mutate(
    status = as.integer(status == 1),
    sex = factor(sex),
    kk = factor(as.integer(pat.karno >= 70))
  ) -> lung
TableSubgroupCox(Surv(time, status) ~ sex, data = lung, time_eventrate = 100)
TableSubgroupCox(Surv(time, status) ~ sex,
  var_subgroup = "kk", data = lung,
  time_eventrate = 100
)

## survey design
library(survey)
data.design <- svydesign(id = ~1, data = lung)
TableSubgroupCox(Surv(time, status) ~ sex, data = data.design, time_eventrate = 100)
TableSubgroupCox(Surv(time, status) ~ sex,
  var_subgroup = "kk", data = data.design,
  time_eventrate = 100
)
}
\seealso{
\code{\link[purrr]{safely}},\code{\link[purrr]{map}},\code{\link[purrr]{map2}}
 \code{\link[survival]{coxph}}
 \code{\link[survey]{svycoxph}}
 \code{\link[stats]{confint}}
}
