% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_cohesion.R
\name{cohesion}
\alias{cohesion}
\alias{network_density}
\alias{network_components}
\alias{network_cohesion}
\alias{network_adhesion}
\alias{network_diameter}
\alias{network_length}
\title{Measures of network cohesion or connectedness}
\usage{
network_density(.data)

network_components(.data)

network_cohesion(.data)

network_adhesion(.data)

network_diameter(.data)

network_length(.data)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions return values or vectors relating to how connected a network is
and the number of nodes or edges to remove that would increase fragmentation.
\itemize{
\item \code{network_density()}: Measures the ratio of ties to the number
of possible ties
\item \code{network_components()}: Measures the number of (strong) components
in the network.
}
}
\section{Functions}{
\itemize{
\item \code{network_cohesion()}: Returns the minimum number of nodes to remove
from the network needed to increase the number of components.

\item \code{network_adhesion()}: Returns the minimum number of edges needed
to remove from the network to increase the number of components.

\item \code{network_diameter()}: Returns the maximum path length in the network.

\item \code{network_length()}: Returns the average path length in the network.

}}
\section{Cohesion}{

To get the 'weak' components of a directed graph,
please use \code{manynet::to_undirected()} first.
}

\examples{
network_density(mpn_elite_mex)
network_density(mpn_elite_usa_advice)
  network_components(mpn_ryanair)
  network_components(manynet::to_undirected(mpn_ryanair))
network_cohesion(manynet::ison_marvel_relationships)
network_cohesion(manynet::to_giant(manynet::ison_marvel_relationships))
network_adhesion(manynet::ison_marvel_relationships)
network_adhesion(manynet::to_giant(manynet::ison_marvel_relationships))
network_diameter(manynet::ison_marvel_relationships)
network_diameter(manynet::to_giant(manynet::ison_marvel_relationships))
network_length(manynet::ison_marvel_relationships)
network_length(manynet::to_giant(manynet::ison_marvel_relationships))
}
\references{
White, Douglas R and Frank Harary. 2001.
"The Cohesiveness of Blocks In Social Networks: Node Connectivity and Conditional Density."
\emph{Sociological Methodology} 31(1): 305-59.
}
\seealso{
Other measures: 
\code{\link{between_centrality}},
\code{\link{close_centrality}},
\code{\link{closure}},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}},
\code{\link{features}},
\code{\link{heterogeneity}},
\code{\link{hierarchy}},
\code{\link{holes}},
\code{\link{net_diffusion}},
\code{\link{node_diffusion}}
}
\concept{measures}
