# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

rcpp_SurvExpInit <- function(precision, start, end, poptable) {
  .Call('missDeaths_rcpp_SurvExpInit', PACKAGE = 'missDeaths', precision, start, end, poptable)
}

rcpp_Sample <- function(params) {
  .Call('missDeaths_rcpp_Sample', PACKAGE = 'missDeaths', params)
}

rcpp_Resample <- function(data) {
  .Call('missDeaths_rcpp_Resample', PACKAGE = 'missDeaths', data)
}

rcpp_BlindDeath <- function(data, zombies) {
  .Call('missDeaths_rcpp_BlindDeath', PACKAGE = 'missDeaths', data, zombies)
}

rcpp_SimCensorX <- function(data, maxTime, form, D, iterations) {
  .Call('missDeaths_rcpp_SimCensorX', PACKAGE = 'missDeaths', data, maxTime, form, D, iterations)
}

rcpp_SurvTime <- function(year, age, prob, sex) {
  .Call('missDeaths_rcpp_SurvTime', PACKAGE = 'missDeaths', year, age, prob, sex)
}

rcpp_exSimCensorX <- function(data1, form, maxiter) {
  .Call('missDeaths_rcpp_exSimCensorX', PACKAGE = 'missDeaths', data1, form, maxiter)
}

#library functions

md.D <- function(age, sex, year)
{
  D = data.frame(age=age, sex=sex, year=year)
  
  sexlevels = levels(as.factor(D$sex))
  for (i in 1:length(sexlevels))
    if (!(sexlevels[i] %in% c("1", "2")))
      stop ("column 'sex' can only contain values 1 and 2")
  
  if ((min(D$age) < 0) || (max(D$age) > 130 * 365))
    stop ("values in column 'age' out of bounds, should be within [0, 130 * 365] days")
  
  return (D)
}

md.impute <- function(data, f, maxtime, D, ratetable, iterations=4)
{  
  #require(survival)
  #require(rms)
  
  D$year = D$year-D$age
  D$year = 1960 + D$year / 365.2425
  f = deparse(f)
  f = gsub(" ", "", f, fixed = TRUE)

  rcpp_SurvExpInit(6, 1850, as.numeric(format(Sys.Date(), "%Y")), ratetable)
  return (rcpp_SimCensorX(data, maxtime, f, D, iterations))
}

md.survnp <- function(time, status, maxtime, D, ratetable, conf.int=0.95) 
{
  R = NA
  colnames = attributes(ratetable)$dimid
  for (i in 1:length(colnames))
  {
    for (j in 1:length(names(D)))
    {
      if (names(D)[j] == colnames[i])
      {
        if (is.na(R)[1])
          R = data.frame(a=D[,j])
        else
          R = cbind(R, D[,j])
        names(R)[i] = colnames[i] 
      }
    }
  }
  
  return (my.survnp(time, status, R, ratetable, maxtime))
}
  
md.survcox <- function(data, f, maxtime, D, ratetable, iterations=4, R = 50)
{  
  D$year = D$year-D$age
  D$year = 1960 + D$year / 365.2425
  ff = deparse(f)
  ff = gsub(" ", "", ff, fixed = TRUE)
    
  rcpp_SurvExpInit(6, 1850, as.numeric(format(Sys.Date(), "%Y")), ratetable)   
  
  if (R == 1)
  {
    newdata = data
    newdata$time = rcpp_SimCensorX(data, maxtime, ff, D, iterations)
    cox = survival::coxph(f, data=newdata)
    
    return (cox)
  }

  models = list()
  length(models) = R
  for (i in 1:R)
  {
    newdata = data
    newdata$time = rcpp_SimCensorX(data, maxtime, ff, D, iterations)
    models[[i]] = survival::coxph(f, data=newdata)
  }
  
  return (MIcombine(models))
}
