% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpEncodeLmer.R
\name{mlr_pipeops_encodelmer}
\alias{mlr_pipeops_encodelmer}
\alias{PipeOpEncodeLmer}
\title{Impact Encoding with Random Intercept Models}
\format{\code{\link{R6Class}} object inheriting from \code{\link{PipeOpTaskPreprocSimple}}/\code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.}
\description{
Encodes columns of type \code{factor}, \code{character} and \code{ordered}.

PipeOpEncodeLmer() converts factor levels of each factorial column to the
estimated coefficients of a simple random intercept model.
Models are fitted with the glmer function of the lme4 package and are
of the type \code{target ~ 1 + (1 | factor)}.
If the task is a regression task, the numeric target
variable is used as dependent variable and the factor is used for grouping.
If the task is a classification task, the target variable is used as dependent variable
and the factor is used for grouping.
If the target variable is multiclass, for each level of the multiclass target variable,
binary "one vs. rest" models are fitted.

For training, multiple models can be estimated in a cross-validation scheme
to ensure that the same factor level does not always result in identical
values in the converted numerical feature.
For prediction, a global model (which was fitted on all observations
during training) is used for each factor.
New factor levels are converted to the value of the intercept coefficient
of the global model for prediction.
NAs are ignored by the CPO.

Use the \code{\link{PipeOpTaskPreproc}} \verb{$affect_columns} functionality to only encode a subset of
columns, or only encode columns of a certain type.
}
\section{Construction}{
\preformatted{PipeOpEncodeLmer$new(id = "encodelmer", param_vals = list())
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"encodelmer"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpTaskPreproc}}.

The output is the input \code{\link[mlr3:Task]{Task}} with all affected \code{factor}, \code{character} or
\code{ordered} parameters encoded according to the \code{method} parameter.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \code{\link{PipeOpTaskPreproc}}, as well as:
\itemize{
\item \code{target_levels} :: \code{character}\cr
Levels of the target columns.
\item \code{control} :: a named \code{list}\cr
List of coefficients learned via \code{glmer}
}
}

\section{Parameters}{

\itemize{
\item \code{fast_optim}  :: \code{logical(1)} \cr
Initialized to \code{TRUE}.
If \dQuote{fast_optim} is \code{TRUE} (default), a faster (up to 50 percent)
optimizer from the nloptr package is used when fitting the lmer models.
This uses additional stopping criteria which can give suboptimal results.
}
}

\section{Internals}{

Uses the \code{\link[lme4:glmer]{lme4::glmer}}. This is relatively inefficient for features with a large number of levels.
}

\section{Methods}{

Only methods inherited \code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")
poe = po("encodelmer")

task = TaskClassif$new("task",
  data.table::data.table(
    x = factor(c("a", "a", "a", "b", "b")),
    y = factor(c("a", "a", "b", "b", "b"))),
  "x")

poe$train(list(task))[[1]]$data()

poe$state
}
\seealso{
Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputenewlvl}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}
}
\concept{PipeOps}
