% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerAvg.R
\name{mlr_learners_avg}
\alias{mlr_learners_avg}
\alias{LearnerClassifAvg}
\alias{mlr_learners_classif.avg}
\alias{LearnerRegrAvg}
\alias{mlr_learners_regr.avg}
\title{Optimized Weighted Average of Features for Classification and Regression}
\format{
\code{\link{R6Class}} object inheriting from \code{\link[mlr3:LearnerClassif]{mlr3::LearnerClassif}}/\code{\link[mlr3:Learner]{mlr3::Learner}}.
}
\usage{
mlr_learners_classif.avg

mlr_learners_regr.avg
}
\description{
Computes a weighted average of inputs.
Used in the context of computing weighted averages of predictions.

Predictions are averaged using \code{weights} (in order of appearance in the data) which are optimized using
nonlinear optimization from the package "nloptr" for a measure provided in \code{measure} (defaults to \code{classif.acc}
for \code{LearnerClassifAvg} and \code{regr.mse} for \code{LearnerRegrAvg}).
Learned weights can be obtained from \verb{$model}.
Using non-linear optimization is implemented in the SuperLearner R package.
For a more detailed analysis the reader is referred to LeDell (2015).

Note, that weights always sum to 1 by dividing through sum(weights) before weighting
incoming features.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link{LearnerClassif}}, as well as:
\itemize{
\item \code{measure} :: \code{\link[mlr3:Measure]{Measure}} | \code{character} \cr
\code{\link[mlr3:Measure]{Measure}} to optimize for.
Will be converted to a \code{\link[mlr3:Measure]{Measure}} in case it is \code{character}.
Initialized to \code{"classif.ce"}, i.e. misclassification error for classification
and \code{"regr.mse"}, i.e. mean squared error for regression.
\item \code{optimizer} :: \code{\link[bbotk:Optimizer]{Optimizer}} | \code{character(1)}\cr
\code{\link[bbotk:Optimizer]{Optimizer}} used to find optimal thresholds.
If \code{character}, converts to \code{\link[bbotk:Optimizer]{Optimizer}}
via \code{\link[bbotk:opt]{opt}}. Initialized to \code{\link[bbotk:OptimizerNLoptr]{OptimizerNLoptr}}.
Nloptr hyperparameters are initialized to \code{xtol_rel = 1e-8}, \code{algorithm = "NLOPT_LN_COBYLA"}
and equal initial weights for each learner.
For more fine-grained control, it is recommended to supply a instantiated \code{\link[bbotk:Optimizer]{Optimizer}}.
\item \code{log_level} :: \code{character(1)} | \code{integer(1)}\cr
Set a temporary log-level for \code{lgr::get_logger("bbotk")}. Initialized to: "warn".
}
}

\section{Methods}{

\itemize{
\item \verb{LearnerClassifAvg$new(), id = "classif.avg")} \cr
(\code{chr}) -> \code{self} \cr
Constructor.
\item \verb{LearnerRegrAvg$new(), id = "regr.avg")} \cr
(\code{chr}) -> \code{self} \cr
Constructor.
}
}

\references{
\cite{mlr3pipelines}{ledell_2015}
}
\seealso{
Other Learners: 
\code{\link{mlr_learners_graph}}

Other Ensembles: 
\code{\link{PipeOpEnsemble}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_regravg}}
}
\concept{Ensembles}
\concept{Learners}
