\name{ordprobit}
\alias{ordprobit}
\alias{ordprobit.formula}
\alias{ordprobit.exch}
\alias{ordprobit.ar}
\alias{ordprobit.unstr}
\title{
Maximum Likelihood for Repeated Measures Multivariate Ordinal Probit Model
}
\description{
Maximum Likelihood for Repeated Measures Multivariate Ordinal Probit: Exchangeable,
AR(1) and Unstructured Correlation Matrices. Quasi-Newton minimization
of negative log-likelihood is used with approximation of Joe (1995)
for rectangle probabilities for AR(1) and unstructured correlation,
and one-dimensional Romberg integration for exchangeable correlation. 
}
\usage{
ordprobit(x,y,id,corstr="exch",iprint=0,startpar=0)
  or
ordprobit.formula(formula,id,data,corstr="exch",iprint=0,startpar=0)
  or
ordprobit.exch(x,y,id,iprint=0,startpar=0)
ordprobit.ar(x,y,id,iprint=0,startpar=0)
ordprobit.unstr(x,y,id,iprint=0,startpar=0)
}
\arguments{
\item{x}{
   vector or matrix of explanatory variables. Each row corresponds
   to an observation and each column to a variable.  The number of rows of x
   should equal the number of data values in y, and there should be fewer 
   columns than rows.  Missing values are not allowed.
}
\item{y}{
   numeric vector containing the ordinal response. 
   The values must be in the range 1,2,..., number of categories.
   Missing values are not allowed. 
}
\item{id}{
   group or cluster id, should be a vector of positive integers. 
   If AR(1) correlation, records are assumed to
   be ordered within each cluster id. If unstructured correlation,
   the cluster size must be constant, and
   records are assumed to be ordered the same way with each cluster id
   (i.e., jth record within each cluster refers to a common
   time/condition for the repeated measurement). 
   For AR(1) and exchangeable correlation, cluster size can vary.
   For the formula version, include the data structure. 
}
\item{formula}{
  For the formula version of ordprobit, a formula expression as for other
  regression models, of the form "response ~ predictors".
}
\item{data}{
  For the formula version of ordprobit, the data frame which contains
  the variables in the formula, and the cluster id variable.
}
\item{corstr}{
  For ordprobit as a front end to the other three functions,
  corstr="exch" means exchangeable correlation (the default); 
  corstr="ar" means AR(1) correlation;
  corstr="unstr" means unstructured correlation (in which case
  cluster size must be a constant). 
}
\item{iprint}{
  logical indicator, default is FALSE, for whether the iterations for 
  numerical maximum likelihood should be printed.
}
\item{startpar}{
  initial parameter vector in the order: regression coefficients, correlation
  parameter(s). If not supplied, default = 0, startpar will be generated by the
  automatically..
}
}
\value{
  list of MLE of parameters and their associated standard 
  errors, in the order cutpt1,...,cutpt(number of categ-1),b1,...b(number of covariates), rho(s);
  order of rhos is r12,r13,...,r23,...,r(d-1,d) for unstructured
\item{negloglik}{
  value of negative log-likelihood, evaluated at MLE
}
\item{cutpts}{
  MLE of ordered cutpoint parameters
}
\item{beta}{
  MLE of regression parameters
}
\item{rho}{
  MLE of latent correlation parameter for AR(1) and exchangeable correlation 
}
\item{rhomat}{
  MLE of matrix of latent correlation parameter for unstructured correlation 
}
\item{mle}{
  MLE of all parameters for unstructured correlation 
}
\item{cov}{
  estimated covariance matrix of the parameters
}
}
\details{
  To get an initial version working, there are constraints:
  (a) For AR(1) and unstructured correlation, the maximum cluster size 
   is 19 (although the joint probabilities
   get to be too small well before this limit is reached);
  (b) The maximum total number of parameters (regression and latent
   correlation parameters combined is 23). So this means a smaller
   upper bound on the number of predictors for the unstructured correlation.

  Also the performance of the quasi-Newton algorithm gets worse
  as the number of parameters increase, particular with the sample
  size (number of clusters) is too small.

  The default starting point used by the code should usually be OK.
  If the returned cov=estimated covariance matrix is the identity matrix,
  then the quasi-Newton iterations did not finish cleanly with a
  gradient vector that is near zero.
  If this case, it would be useful to use iprint=1 to print the
  iterations, and try different starting points in startpar to
  check on the sensitivity to the starting point. The SE estimates
  are better if the quasi-Newton iterations finish with gradient
  vector closer to zero.
}
\references{
  Anderson, J.A. and Pemberton, J.D. (1985). The grouped continuous model for
    multivariate ordered categorical variables and covariate adjustment.  
    Biometrics,  41, 875-885.

  Joe, H (1995). Approximations to multivariate  normal rectangle
    probabilities based on conditional expectations, J Amer Stat Assoc, 90, 957-964.
}
\author{H. Joe, Statistics Department, UBC, with assistance of Laing Wei Chou}
\examples{
data(ordinalex)
x=ordinalex$x
y=ordinalex$y
id=ordinalex$id

# various ways of using ordprobit are shown here
# exchangeable dependence 
ord.exch = ordprobit.exch(x,y,id)
print(ord.exch)

# AR(1) dependence 
ord.ar = ordprobit(x,y,id,corstr="ar")
print(ord.ar)

# unstructured correlation matrix
ord.unstr = ordprobit.formula(y~x,ordinalex$id,data=ordinalex,corstr="unstr")
print(ord.unstr)
}
\keyword{models}
