% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_is_posix.R
\name{col_is_posix}
\alias{col_is_posix}
\title{Do the columns contain \code{POSIXct} dates?}
\usage{
col_is_posix(x, columns, actions = NULL, brief = NULL, active = TRUE)
}
\arguments{
\item{x}{A data frame, tibble, or an agent object of class \code{ptblank_agent}.}

\item{columns}{The column (or a set of columns, provided as a character
vector) to which this validation should be applied.}

\item{actions}{A list containing threshold levels so that the validation step
can react accordingly when exceeding the set levels. This is to be created
with the \code{\link[=action_levels]{action_levels()}} helper function.}

\item{brief}{An optional, text-based description for the validation step.}

\item{active}{A logical value indicating whether the validation step should
be active. If the step function is working with an agent, \code{FALSE} will make
the validation step inactive (still reporting its presence and keeping
indexes for the steps unchanged). If the step function will be operating
directly on data, then any step with \code{active = FALSE} will simply pass the
data through with no validation whatsoever. The default for this is \code{TRUE}.}
}
\value{
Either a \code{ptblank_agent} object or a table object, depending on what
was passed to \code{x}.
}
\description{
The \code{col_is_posix()} validation step function checks whether one or more
columns is of the R \code{POSIXct} date-time type. Like many of the
\verb{col_is_*()}-type functions in \strong{pointblank}, the only requirement is a
specification of the column names. This function can be used directly on a
data table or with an \emph{agent} object (technically, a \code{ptblank_agent} object).
Each validation step will operate over a single test unit, which is whether
the column is a \code{POSIXct}-type column or not.
}
\details{
If providing multiple column names, the result will be an expansion of
validation steps to that number of column names (e.g., \code{vars(col_a, col_b)}
will result in the entry of two validation steps). Aside from column names
in quotes and in \code{vars()}, \strong{tidyselect} helper functions are available for
specifying columns. They are: \code{starts_with()}, \code{ends_with()}, \code{contains()},
\code{matches()}, and \code{everything()}.

Often, we will want to specify \code{actions} for the validation. This argument,
present in every validation step function, takes a specially-crafted list
object that is best produced by the \code{\link[=action_levels]{action_levels()}} function. Read that
function's documentation for the lowdown on how to create reactions to
above-threshold failure levels in validation. The basic gist is that you'll
want at least a single threshold level (specified as either the fraction test
units failed, or, an absolute value), often using the \code{warn_at} argument.
This is especially true when \code{x} is a table object because, otherwise,
nothing happens. For the \verb{col_is_*()}-type functions, using
\code{action_levels(warn_at = 1)} or \code{action_levels(stop_at = 1)} are good choices
depending on the situation (the first produces a warning, the other
\code{stop()}s).

Want to describe this validation step in some detail? Keep in mind that this
is only useful if \code{x} is an \emph{agent}. If that's the case, \code{brief} the agent
with some text that fits. Don't worry if you don't want to do it. The
\emph{autobrief} protocol is kicked in when \code{brief = NULL} and a simple brief will
then be automatically generated.

Verification step where a table column is expected to consist entirely of
R \code{POSIXct} dates.
}
\section{Function ID}{

2-18
}

\examples{
# Create a simple table with a
# column of `POSIXct` values
tbl <-
  dplyr::tibble(
    a = as.POSIXct(
      strptime(
        "2011-03-27 01:30:00",
        "\%Y-\%m-\%d \%H:\%M:\%S")
      )
  )

# Validate that column `a` in the
# table is classed as `POSIXct`
agent <-
  create_agent(tbl = tbl) \%>\%
  col_is_posix(vars(a)) \%>\%
  interrogate()

# Determine if this column
# validation has passed by
# using `all_passed()`
all_passed(agent)

}
\seealso{
Other Validation Step Functions: 
\code{\link{col_exists}()},
\code{\link{col_is_character}()},
\code{\link{col_is_date}()},
\code{\link{col_is_factor}()},
\code{\link{col_is_integer}()},
\code{\link{col_is_logical}()},
\code{\link{col_is_numeric}()},
\code{\link{col_schema_match}()},
\code{\link{col_vals_between}()},
\code{\link{col_vals_equal}()},
\code{\link{col_vals_gte}()},
\code{\link{col_vals_gt}()},
\code{\link{col_vals_in_set}()},
\code{\link{col_vals_lte}()},
\code{\link{col_vals_lt}()},
\code{\link{col_vals_not_between}()},
\code{\link{col_vals_not_equal}()},
\code{\link{col_vals_not_in_set}()},
\code{\link{col_vals_not_null}()},
\code{\link{col_vals_null}()},
\code{\link{col_vals_regex}()},
\code{\link{conjointly}()},
\code{\link{rows_distinct}()}
}
\concept{Validation Step Functions}
