% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{wibbelink2017}
\alias{wibbelink2017}
\title{Studies on juvenile recidivism}
\format{
A data frame with 100 rows and 10 variables.
\itemize{
\item \code{study_id}: unique id for each study
\item \code{es_id}: unique id for each effect size
\item \code{yi}: observed effect sizes (Cohen's d)
\item \code{vi}: sampling variance (SE^2)
\item \code{pstatpub}: dummy variable encoding whether the study was published, 0 = unpublished, 1 = published
\item \code{pstatnotpub}: dummy variable encoding whether the study was unpublished, 0 = published, 1 = unpublished
\item \code{typgen}: dummy variable encoding the type of recidivism behavior 0 = not applicable, 1 = general
\item \code{typovert}: dummy variable encoding the type of recidivism behavior 0 = not applicable, 1 = overt
\item \code{typcovert}: dummy variable encoding the type of recidivism behavior 0 = not applicable, 1 = covert
\item \code{pyear}: the publication year of the study; mean-centered
}
}
\source{
\href{https://www.tqmp.org/RegularArticles/vol12-3/p154/}{The Quantitative Methods in Psychology}
}
\usage{
data(wibbelink2017)
}
\description{
Results from 17 studies, including 100 effect sizes (Cohen's D) on the associations between mental health disorders of
delinquent juveniles and subsequent delinquent behavior
}
\references{
Wibbelink et al. (2017). A meta-analysis of the association between mental health disorders and juvenile recidivism.
\emph{Aggression and Violent Behavior}, \emph{33}, 78-90.
(\href{https://www.sciencedirect.com/science/article/pii/S1359178917300149}{ScienceDirect})
}
\keyword{datasets}
