% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_time.R
\docType{class}
\name{AccrualTime}
\alias{AccrualTime}
\title{Accrual Time}
\description{
Class for the definition of accrual time and accrual intensity.
}
\details{
\code{AccrualTime} is a class for the definition of accrual time and accrual intensity.
}
\section{Fields}{

\describe{
\item{\code{endOfAccrualIsUserDefined}}{If \code{TRUE}, the end of accrual has to be defined by the user (i.e., the length of \code{accrualTime} is equal to the length of \code{accrualIntensity -1}). Is a logical vector of length 1.}

\item{\code{followUpTimeMustBeUserDefined}}{Specifies whether follow up time needs to be defined or not. Is a logical vector of length 1.}

\item{\code{maxNumberOfSubjectsIsUserDefined}}{If \code{TRUE}, the maximum number of subjects has been specified by the user, if \code{FALSE}, it was calculated.}

\item{\code{maxNumberOfSubjectsCanBeCalculatedDirectly}}{If \code{TRUE}, the maximum number of subjects can directly be calculated. Is a logical vector of length 1.}

\item{\code{absoluteAccrualIntensityEnabled}}{If \code{TRUE}, absolute accrual intensity is enabled. Is a logical vector of length 1.}

\item{\code{accrualTime}}{The assumed accrual time intervals for the study. Is a numeric vector.}

\item{\code{accrualIntensity}}{The absolute accrual intensities. Is a numeric vector of length \code{kMax}.}

\item{\code{accrualIntensityRelative}}{The relative accrual intensities.}

\item{\code{maxNumberOfSubjects}}{The maximum number of subjects for power calculations. Is a numeric vector.}

\item{\code{remainingTime}}{In survival designs, the remaining time for observation. Is a numeric vector of length 1.}

\item{\code{piecewiseAccrualEnabled}}{Indicates whether piecewise accrual is selected. Is a logical vector of length 1.}
}}


\keyword{internal}
