% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_methods.R, R/components.R
\name{print.adlp_component}
\alias{print.adlp_component}
\alias{adlp_component}
\title{Accident and Development period Adjusted Linear Pools Component Models}
\usage{
\method{print}{adlp_component}(x, ...)

adlp_component(
  model_train,
  model_full,
  calc_dens,
  calc_mu,
  calc_cdf,
  sim_fun,
  ...
)
}
\arguments{
\item{x}{Object of class \code{adlp_component}}

\item{...}{Other named parameters required for the model or any of its
related functions to run.}

\item{model_train}{Model trained on training data}

\item{model_full}{Model trained on all in-sample data}

\item{calc_dens}{function to calculate the pdf of each point}

\item{calc_mu}{function to calculate the estimated mean of each point}

\item{calc_cdf}{function to calculate the cdf of each point}

\item{sim_fun}{function to simulate new from}
}
\value{
Object of class \code{adlp_component}
}
\description{
Class to store component models and related functions required for ADLP
estimation, prediction and goodness of fit.
}
\details{
Component models \code{model_train} and \code{model_full} are designed to be objects of
class \code{glm}, \code{lm}, or similar. The models would desirably have a S3 method for
`formula. For models that do not fit under this umbrella,
see \link[ADLP]{custom_model}. For a potential list of candidate models,
one might refer to Avanzi, Li, Wong and Xian (2022).

Functions as assumed to have the following parameter naming convention:
\itemize{
\item{\code{y} as the response variable}
\item{\code{model} as the modeling object \code{model_train} or \code{model_full}}
\item{\code{newdata} to designate new data}
}
Other inputs not in this list will need to be intialised with the \code{adlp_component}
}
\examples{
data("test_claims_dataset")

train_val <- train_val_split_method1(
    df = test_claims_dataset,
    tri.size = 40,
    val_ratio = 0.3,
    test = TRUE
)
train_data <- train_val$train
valid_data <- train_val$valid
insample_data <- rbind(train_data, valid_data)

base_model1 <- glm(formula = claims~factor(dev),
                   family=gaussian(link = "identity"), data=train_data)

base_model1_full <- update(base_model1, data = insample_data)

dens_normal <- function(y, model, newdata){
    pred_model <- predict(model, newdata=newdata, type="response", se.fit=TRUE)
    mu <- pred_model$fit
    sigma <- pred_model$residual.scale
    return(dnorm(x=y, mean=mu, sd=sigma))
}

cdf_normal<-function(y, model, newdata){
    pred_model <- predict(model, newdata=newdata, type="response", se.fit=TRUE)
    mu <- pred_model$fit
    sigma <- pred_model$residual.scale
    return(pnorm(q=y, mean=mu, sd=sigma))
}

mu_normal<-function(model, newdata){
    mu <- predict(model, newdata=newdata, type="response")
    mu <- pmax(mu, 0)
    return(mu)
}

sim_normal<-function(model, newdata){
    pred_model <- predict(model, newdata=newdata, type="response", se.fit=TRUE)
    mu <- pred_model$fit
    sigma <- pred_model$residual.scale

    sim <- rnorm(length(mu), mean=mu, sd=sigma)
    sim <- pmax(sim, 0)
    return(sim)
}

base_component1 = adlp_component(
    model_train = base_model1,
    model_full = base_model1_full,
    calc_dens = dens_normal,
    calc_cdf = cdf_normal,
    calc_mu = mu_normal,
    sim_fun = sim_normal
)

}
\references{
Avanzi, B., Li, Y., Wong, B., & Xian, A. (2022). Ensemble distributional forecasting for insurance loss reserving. arXiv preprint arXiv:2206.08541.
}
