% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHPtools.R
\name{revisedConsistency}
\alias{revisedConsistency}
\title{Evaluate Revised Consistency}
\usage{
revisedConsistency(PCM, typePCM = TRUE)
}
\arguments{
\item{PCM}{A pairwise comparison matrix}

\item{typePCM}{boolean flag indicating if the first argument is a PCM or a
vector of upper triangular elements}
}
\value{
A list of four elements,
revCons = the revised consistency classification,
inconGM = the Geometric Mean measure of inconsistency with the best 'PCM',
dQrtl = the preference heterogeneity quartile for the normalized
eigenvector, and diff = the preference heterogeneity measure
}
\description{
This function returns the revised consistency classification
for a PCM, evaluated by comparison with the threshold of consistency for
intentional PCMs in the same preference heterogeneity quartile. The measure
for inconsistency is the geometric mean of ratios in comparison with the
corresponding benchmark PCM.
}
\examples{
revCon1 <- revisedConsistency(matrix(
                 c(1,1/4,1/4,7,1/5, 4,1,1,9,1/4, 4,1,1,8,1/4,
                 1/7,1/9,1/8,1,1/9, 5,4,4,9,1), nrow=5, byrow=TRUE))
revCon1
revCon2 <- revisedConsistency(c(7,1,9,8, 1/6,7,9, 9,9, 5), typePCM=FALSE)
revCon2
}
