% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moses.extreme.reactions.R
\name{moses.extreme.reactions}
\alias{moses.extreme.reactions}
\title{Perform Moses test for extreme reactions}
\usage{
moses.extreme.reactions(
  x,
  y,
  H0 = NULL,
  max.exact.cases = 1000,
  do.exact = TRUE
)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{1000})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{moses.extreme.reactions()} performs the Moses test for extreme reactions and is used in chapter 6 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 6.14 from "Applied Nonparametric Statistical Methods" (5th edition)
moses.extreme.reactions(ch6$groupI.amended, ch6$groupII)
moses.extreme.reactions(ch6$groupI.amended, ch6$groupII)

}
