% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat15}
\alias{simDat15}
\title{Simulate data for Chapter 15: Comparing two groups of binomial counts}
\usage{
simDat15(N = 50, theta.cr = 12/50, theta.ch = 38/50)
}
\arguments{
\item{N}{Number of sites}

\item{theta.cr}{Probability of presence for cross-leaved gentian}

\item{theta.ch}{Probability of presence for chiltern gentian}
}
\value{
A list of simulated data and parameters.
  \item{N}{Number of sites}
  \item{theta.cr}{Probability for cross-leaved gentian}
  \item{theta.ch}{Probability for chiltern gentian}
  \item{y}{Simulated presence/absence data}
  \item{species.long}{Species indicator (longform), 1 = chiltern}
  \item{C}{Aggregated presence/absence data}
  \item{species}{Species indicator for aggregated data}
  \item{chiltern}{Effect of chiltern (difference in species intercepts)}
}
\description{
Generate presence/absence data for two gentian species (Bernoulli variant)
}
\examples{
str(dat <- simDat15())      # Implicit default arguments

# Revert to "Binomial model-of-the-mean"
# (Increase sample size to reduce sampling variability)
str(dat <- simDat15(N = 100, theta.cr = 40/100, theta.ch = 40/100)) 

}
\author{
Marc Kéry
}
