% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1_plot_T.R
\name{step1_plot_T}
\alias{step1_plot_T}
\title{Focus on Temperature}
\usage{
step1_plot_T(
  step1_down_object,
  focus_T = NULL,
  xname = NULL,
  yname = NULL,
  xlim = NULL,
  ylim = NULL,
  ribbon = FALSE
)
}
\arguments{
\item{step1_down_object}{The fit object from the step1.down function (required).}

\item{focus_T}{Selected temperature to highlight on the plot.}

\item{xname}{Label for the x-axis (optional).}

\item{yname}{Label for the y-axis (optional).}

\item{xlim}{the x-axis limits (optional).}

\item{ylim}{the y-axis limits (optional).}

\item{ribbon}{adds shade to confidence and prediction intervals (optional).}
}
\value{
ggplot2 object with focus on chosen temperature.
}
\description{
Plot the stability data and visualise the predictions with focus on
one temperature.
}
\details{
Plot the stability data and visualise the predictions focusing on one
chosen temperature with confidence and prediction intervals.
}
\examples{
#Load potency data
data(potency)

#Run step1_down fit
fit1 <- step1_down(data = potency, y = "Potency", .time = "Time",
 C = "Celsius", zero_order = TRUE)

#Plot raw data with prediction curves with focus on temperature in dataset.
#Also limit x-axis to values between 0 and 10 and limit y-axis to values between 0 and 12.
step1_plot_T(fit1, focus_T = 5,ribbon = TRUE, xlim = c(0,10), ylim = c(0,12),
 xname = "Time (Month)", yname = "Potency")

#Plot raw data with prediction curves with focus on temperature not in dataset.
#Also limit x-axis to values between 0 and 10 and limit y-axis to values between 0 and 12.
step1_plot_T(fit1, focus_T = -10,ribbon = TRUE, xlim = c(0,10), ylim = c(0,12),
 xname = "Time (Months)", yname = "Potency")

}
