% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_tests.r
\name{orderedHypergeometric}
\alias{orderedHypergeometric}
\title{Ordered Hypergeometric Test}
\usage{
orderedHypergeometric(genelist, background, annotations)
}
\arguments{
\item{genelist}{Character vector of gene names, assumed to be ordered by decreasing importance. 
For example, the genes could be ranked by decreasing significance of differential expression.}

\item{background}{Character vector of gene names. List of all genes used as a statistical background (i.e., the universe).}

\item{annotations}{Character vector of gene names. A gene set representing a functional term, process or biological pathway.}
}
\value{
a list with the items:
  \describe{
    \item{p_val}{The lowest obtained p-value}
    \item{ind}{The index of \code{genelist} such that \code{genelist[1:ind]}
      gives the lowest p-value}
 }
}
\description{
Perform a series of hypergeometric tests (a.k.a. Fisher's Exact tests), on a ranked list of genes ordered
by significance against a list of annotation genes. The hypergeometric tests are executed with 
increasingly larger numbers of genes representing the top genes in order of decreasing scores. 
The lowest p-value of the series is returned as the optimal enriched intersection of the ranked list of genes
and the biological term (pathway).
}
\examples{
   orderedHypergeometric(c('HERC2', 'SP100'), c('PHC2', 'BLM', 'XPC', 'SMC3', 'HERC2', 'SP100'),
                         c('HERC2', 'PHC2', 'BLM'))
}
