% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{download_dhs_datasets}
\alias{download_dhs_datasets}
\title{Download WHO ADM2 Boundaries with Partial Updateads the latest PR (household)
and GE (geographic) DHS datasets for specified countries.}
\usage{
download_dhs_datasets(
  country_codes,
  cache_path = here::here("01_data", "1a_survey_data", "raw"),
  output_dir_root = here::here("01_data", "1a_survey_data", "raw"),
  survey_id = NULL,
  email,
  project,
  verbose = TRUE,
  clear_cache = TRUE
)
}
\arguments{
\item{country_codes}{A character vector of ISO3 country codes.}

\item{cache_path}{A character string specifying the cache path for RDHS.}

\item{output_dir_root}{A character string specifying the root directory for
output.}

\item{survey_id}{A character vector of survey IDs. If NULL, uses latest
survey.}

\item{email}{A character string. Email registered with DHS.}

\item{project}{A character string. Project name as registered with DHS.}

\item{verbose}{Logical for rdhs setup and messages to be printed.}

\item{clear_cache}{Logical whether to clear cache before downloading.}
}
\value{
Invisibly returns a list of downloaded dataset filenames.
}
\description{
Download WHO ADM2 Boundaries with Partial Updateads the latest PR (household)
and GE (geographic) DHS datasets for specified countries.
}
