% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATM_simulations.R
\name{simulate_genetic_disease_from_topic}
\alias{simulate_genetic_disease_from_topic}
\title{Simulate genetic-disease-topic structure (step 2)}
\usage{
simulate_genetic_disease_from_topic(
  para,
  genetics_population,
  causal_disease,
  disease_number,
  ds_per_idv = 6.1,
  itr_effect = 0,
  topic2disease = 2,
  v2t = 20,
  liability_thre = 0.8
)
}
\arguments{
\item{para}{Simulated topic parameters; the first element returned by \code{simulate_topics()}.}

\item{genetics_population}{Simulated genotypes; the second element returned by \code{simulate_topics()}.}

\item{causal_disease}{Simulated causal disease; the third element returned by \code{simulate_topics()}.}

\item{disease_number}{Number of additional diseases to simulate from the topic.
The total number of diseases will be \code{disease_number + 5}.}

\item{ds_per_idv}{Mean number of diseases per individual (default \code{6.1}, as observed in UKB).}

\item{itr_effect}{Interaction effect size to simulate (default \code{0}).}

\item{topic2disease}{Topic-to-disease effect size (default \code{2}).}

\item{v2t}{Number of variants that affect topic 1 (must match the value used in \code{simulate_topics()}).}

\item{liability_thre}{Liability threshold for simulating disease: the proportion set to \emph{healthy}.
For example, \code{0.8} means the top 20\% of liability are set to \emph{diseased} (default \code{0.8}).}
}
\value{
A list with four elements:
\itemize{
\item \code{rec_data}: Simulated disease records (primary output).
\item \code{ds_list}: Auxiliary data objects used in the simulation.
\item \code{interact_disease}: Binary disease outcomes for configuration 2.
\item \code{pleiotropy_disease}: Binary disease outcomes for configuration 3.
}
}
\description{
Second step of the two-step simulation. Consumes outputs from
\code{simulate_topics()} and generates disease outcomes under several
genetic/topic-effect configurations.
}
\details{
Five configurations across three SNP sets:
\enumerate{
\item \strong{SNP -> disease -> topic}: SNP IDs 1-20; disease ID \code{para$D + 1}; topic ID 1.
\item \strong{SNP * topic -> disease}: SNP IDs 41-60; disease ID \code{para$D + 2}; topic ID 1.
\item \strong{SNP -> topic -> disease; SNP -> disease}: SNP IDs 21-(20 + v2t); disease ID \code{para$D + 3}; topic ID 1.
\item \strong{SNP -> topic -> disease; SNP + SNP^2 -> disease}: SNP IDs 21-(20 + v2t); disease ID \code{para$D + 4}; topic ID 1.
\item \strong{SNP -> topic + topic^2 -> disease; SNP -> disease}: SNP IDs 21-(20 + v2t); disease ID \code{para$D + 5}; topic ID 1.
}
}
\examples{
set.seed(1)
# Minimal, fast example
rslts <- simulate_topics(topic_number = 2, pop_sz = 1000,
                         disease2topic = 0.1, v2t = 20)
para_sim            <- rslts[[1]]
genetics_population <- rslts[[2]]
causal_disease      <- rslts[[3]]

reslt_ds <- simulate_genetic_disease_from_topic(
  para_sim, genetics_population, causal_disease,
  disease_number = 20, itr_effect = 1,
  topic2disease = 2, v2t = 20
)
rec_data <- reslt_ds[[1]]
}
\seealso{
\code{\link[=simulate_topics]{simulate_topics()}}
}
