% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_timeRange.R
\name{monitor_timeRange}
\alias{monitor_timeRange}
\title{Get the time range for a monitor}
\usage{
monitor_timeRange(monitor = NULL, timezone = NULL)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{timezone}{Olson timezone for the returned dates.}
}
\value{
A vector containing the minimum and maximum times of a
\emph{mts_monitor} object.
}
\description{
This function is a wrapper for \code{range(monitor$data$datetime)}
and is convenient for use in data pipelines.

Dates will be returned in the timezone associated with
\code{monitor$data$datetime} which is typically "UTC" unless
\code{timezone} is specified.
}
\examples{
Carmel_Valley \%>\%
  monitor_timeRange(timezone = "America/Los_Angeles")
}
