% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition_chisq.R
\name{transition_chisq}
\alias{transition_chisq}
\title{Perform a Chi-Squared Test for Transition Counts}
\usage{
transition_chisq(sequences, alpha = 0.05)
}
\arguments{
\item{sequences}{A vector of sequences, where each sequence is a character string with elements separated by spaces.}

\item{alpha}{A numeric value representing the significance level for the chi-squared test. Default is 0.05.}
}
\value{
A list with two elements:
\item{significant}{A logical value indicating whether the chi-squared test result is significant at the given significance level.}
\item{p_value}{A numeric value representing the p-value of the chi-squared test.}
}
\description{
This function performs a chi-squared test to determine if there are significant differences between observed and expected transition counts in sequences. It calculates the chi-squared statistic and tests the null hypothesis that transitions occur according to the expected frequencies.
}
\details{
The function calculates observed transition counts from the input sequences, computes expected transition counts based on row and column sums, and performs a chi-squared test to compare observed and expected counts. The test determines if the transitions in the sequences differ significantly from what would be expected by chance.
}
\examples{
# Define sequences
sequences <- c('e1 e2 e3', 'e2 e1 e3', 'e3 e2 e1')

# Perform chi-squared test
transition_chisq(sequences, alpha = 0.05)
}
