% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance_matrix_knn_algorithm.R
\name{distance_matrix_dtw}
\alias{distance_matrix_dtw}
\title{Normalized distance matrix from dynamic time-warping distance}
\usage{
distance_matrix_dtw(k, unit, maxwindow)
}
\arguments{
\item{k}{The parameter $k$ controls the contribution of the sum of squares
comparison as a value-based metric and the $Cort$ quantity as a behavioral
metric; when $k=0$, then the distance is equal to the value-based metric,
on the other hand, when $k=6$ the distance is mainly determined by the value
of the temporal correlation $Cort$.}

\item{unit}{A matrix representing a multivariate time series where each
column is a univariate time series.}

\item{maxwindow}{the maximum shift allowed between time series points.}
}
\value{
a matrix with pairwise distances
}
\description{
pairwise distance matrix of a multivariate time series based on a minimal
mapping between two time series weighted by temporal correlation
}
\examples{
X=matrix( rnorm(200), ncol=10  )
k=2
maxwindow=10
distance_matrix_dtw(k,X,maxwindow)
}
\seealso{
For more details, check the \code{dtw} package documentation on CRAN
}
