% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArArRedux.R
\name{process}
\alias{process}
\title{Process logratio data and calculate 40Ar/39Ar ages}
\usage{
process(X, irr, fract = NULL, ca = NULL, k = NULL)
}
\arguments{
\item{X}{an object of class \code{\link{redux}}}

\item{irr}{the irradiation schedule}

\item{fract}{list with air shot data (one item per denominator isotope)}

\item{ca}{an object of class \code{\link{logratios}} with
Ca-interference data (not necessary if interferences are included in X)}

\item{k}{an object of class \code{\link{logratios}} with
K-interference data (not necessary if interferences are included in X)}
}
\description{
Performs detector calibration, mass fractionation correction, decay
corrections, interference corrections, interpolates J-factors and
calculates ages.
}
\examples{
data(Melbourne)
ages <- process(Melbourne$X,Melbourne$irr,Melbourne$fract)
summary(ages)
}
