% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ACSN_Enrichment.R
\name{represent_enrichment}
\alias{represent_enrichment}
\title{Graphic representation of enrichment}
\usage{
represent_enrichment(enrichment, plot = "heatmap", scale = "log",
  low = "steelblue", high = "white", nrow = 1, sample_name = "Sample",
  na.value = "grey")
}
\arguments{
\item{enrichment}{Data frame or list of dataframes with p-values or corrected p-values (whenever available) and module names for representation.
The name of the dataframe will be used as sample name.}

\item{plot}{Any of "heatmap" or "bar"}

\item{scale}{Any of "log" or "identity"}

\item{low}{Color to be used in heatmap mode corresponding to lowest value}

\item{high}{Color to be used in heatmap mode corresponding to highest value}

\item{nrow}{Number of rows of the grid for display in bar mode.}

\item{sample_name}{used only is enrichment is a dataframe}

\item{na.value}{color for the missing values in the heatmap}
}
\description{
Graphic representation of enrichment
}
\examples{
represent_enrichment(enrichment = list(SampleA = enrichment_test[1:10,],
SampleB = enrichment_test[3:10,]), plot = "heatmap", scale = "log")
}

