modavg.mult <-
function(cand.set, parm, modnames, c.hat = 1, conf.level = 0.95, second.ord = TRUE, nobs = NULL,
         exclude = NULL, warn = TRUE, uncond.se = "revised"){
#check if class is appropriate
#extract classes
  mod.class <- unlist(lapply(X=cand.set, FUN=class))
#check if all are identical
  check.class <- unique(mod.class)
  
  if(!identical(check.class, c("multinom", "nnet"))) {stop("This function is only appropriate with the \'multinom\' class\n")}
    
#extract model formula for each model in cand.set    
  mod_formula<-lapply(cand.set, FUN=function(i) colnames(summary(i)$coefficients)) 

  nmods <- length(cand.set)
  
#setup matrix to indicate presence of parm in the model
  include <- matrix(NA, nrow=nmods, ncol=1)
    #add a check for multiple instances of same variable in given model (i.e., interactions)
  include.check <- matrix(NA, nrow=nmods, ncol=1)

    #iterate over each formula in mod_formula list
  for (i in 1:nmods) {
    idents <- NULL
    idents.check <- NULL
    form <- mod_formula[[i]]

    #iterate over each element of formula[[i]] in list
    for (j in 1:length(form)) {
      idents[j] <- identical(parm, form[j])
      idents.check[j] <- ifelse(attr(regexpr(parm, form[j]), "match.length")=="-1", 0, 1)  
    }
    include[i] <- ifelse(any(idents==1), 1, 0)
    include.check[i] <- ifelse(sum(idents.check)>1, "duplicates", "OK")
  }

#####################################################
#exclude == NULL; warn=TRUE:  warn that duplicates occur and stop
  if(is.null(exclude) && identical(warn, TRUE)) {
    if(any(include.check == "duplicates")) {
      stop("Some models possibly include more than one instance of the parameter of interest.\n",
           "This may be due to the presence of interaction/polynomial terms, or variables\n",
           "with similar names:\n",
           "\tsee \"?modavg\" for details on variable specification and \"exclude\" argument\n")
    }

  }
  


#exclude == NULL; warn=FALSE:  compute model-averaged beta estimate from models including variable of interest,
    #assuming that the variable is not involved in interaction or higher order polynomial (x^2, x^3, etc...),
    #warn that models were not excluded
  if(is.null(exclude) && identical(warn, FALSE)) {
    if(any(include.check == "duplicates")) {
      warning("Multiple instances of parameter of interest in given model is presumably\n",
              "not due to interaction or polynomial terms - these models will not be\n",
              "excluded from the computation of model-averaged estimate\n")
    }
    
  }

    #if exclude is list  
  if(is.list(exclude)) {

    #determine number of elements in exclude
    nexcl <- length(exclude)

      #check each formula for presence of exclude variable extracted with formula( )  - in multinom( ) must be extracted from call   
    not.include <- lapply(cand.set, FUN=function(i) formula(i$call))

      #set up a new list with model formula
    forms <- list()
    for (i in 1:nmods) {
      form.tmp <- strsplit(as.character(not.include[i]), split="~")[[1]][-1]
      if(attr(regexpr("\\+", form.tmp), "match.length")==-1) {
        forms[i] <- form.tmp
      } else {forms[i] <- strsplit(form.tmp, split=" \\+ ")}
    }

      #additional check to see whether some variable names include "+"
    check.forms <- unlist(lapply(forms, FUN=function(i) any(attr(regexpr("\\+", i), "match.length")>0)[[1]]))
    if (any(check.forms==TRUE)) stop("Please avoid \"+\" in variable names")


      #search within formula for variables to exclude
    mod.exclude <- matrix(NA, nrow=nmods, ncol=nexcl)
    
      #iterate over each element in exclude list
    for (var in 1:nexcl) {

      #iterate over each formula in mod_formula list
      for (i in 1:nmods) {
        idents <- NULL
        form.excl <- forms[[i]]

          #iterate over each element of forms[[i]]
        for (j in 1:length(form.excl)) {
          idents[j] <- identical(exclude[var][[1]], form.excl[j])
        }
        mod.exclude[i,var] <- ifelse(any(idents==1), 1, 0)
      }    
      
    }
  
      #determine outcome across all variables to exclude
    to.exclude <- rowSums(mod.exclude)
  
  
      #exclude models following models from model averaging  
    include[which(to.exclude>=1)] <- 0
      
    
  }
  

  
#add a check to determine if include always == 0
  if (sum(include)==0) {stop("Parameter not found in any of the candidate models") }

  new.cand.set<-cand.set[which(include==1)] #select models including a given parameter
  new.mod.name<-modnames[which(include==1)]    #update model names
##


#determine number of levels - 1
  mod.levels <- lapply(cand.set, FUN=function(i) rownames(summary(i)$coefficients)) #extract level of response variable 
  check.levels <- unlist(unique(mod.levels))


#recompute AIC table and associated measures
  new_table<-aictab.mult(cand.set=new.cand.set, modnames=new.mod.name, sort=FALSE, c.hat=c.hat,
                         second.ord=second.ord, nobs=nobs) 

#create object to store model-averaged estimate and SE's of k - 1 level of response
  out.est <- matrix(data=NA, nrow=length(check.levels), ncol=4)
  colnames(out.est) <- c("Mod.avg.est", "Uncond.SE", "Lower.CL", "Upper.CL")
  rownames(out.est) <- check.levels

#iterate over levels of response variable
  for (g in 1:length(check.levels)) {
  #extract beta estimate for parm
    new_table$Beta_est <- unlist(lapply(new.cand.set, FUN=function(i) coef(i)[check.levels[g], paste(parm)]))
  #extract SE of estimate for parm
    new_table$SE <- unlist(lapply(new.cand.set, FUN=function(i) summary(i)$standard.errors[check.levels[g], paste(parm)]))

#if c-hat is estimated adjust the SE's by multiplying with sqrt of c-hat
    if(c.hat > 1) {new_table$SE<-new_table$SE*sqrt(c.hat)} 

#compute model-averaged estimates, unconditional SE, and 95% CL
    #AICc
    if(c.hat == 1 && second.ord == TRUE) {
      Modavg_beta <- sum(new_table$AICcWt*new_table$Beta_est)

      #unconditional SE based on equation 4.9 of Burnham and Anderson 2002
      if(identical(uncond.se, "old")) {
        Uncond_SE <- sum(new_table$AICcWt*sqrt(new_table$SE^2 + (new_table$Beta_est- Modavg_beta)^2))
      }

      #revised computation of unconditional SE based on equation 6.12 of Burnham and Anderson 2002; Anderson 2008, p. 111
      if(identical(uncond.se, "revised")) {
        Uncond_SE <- sqrt(sum(new_table$AICcWt*(new_table$SE^2 + (new_table$Beta_est- Modavg_beta)^2)))
      }
    }


    #QAICc
    #if c-hat is estimated compute values accordingly and adjust table names
    if(c.hat > 1 && second.ord == TRUE) {
      Modavg_beta <- sum(new_table$QAICcWt*new_table$Beta_est)

      #unconditional SE based on equation 4.9 of Burnham and Anderson 2002
      if(identical(uncond.se, "old")) {
        Uncond_SE <- sum(new_table$QAICcWt*sqrt(new_table$SE^2 + (new_table$Beta_est- Modavg_beta)^2))
      }

      #revised computation of unconditional SE based on equation 6.12 of Burnham and Anderson 2002; Anderson 2008, p. 111
      if(identical(uncond.se, "revised")) {
        Uncond_SE <- sqrt(sum(new_table$QAICcWt*(new_table$SE^2 + (new_table$Beta_est- Modavg_beta)^2)))
      } 
    }

    
    #AIC
    if(c.hat == 1 && second.ord == FALSE) {
      Modavg_beta <- sum(new_table$AICWt*new_table$Beta_est)

      #unconditional SE based on equation 4.9 of Burnham and Anderson 2002
      if(identical(uncond.se, "old")) {
        Uncond_SE <- sum(new_table$AICWt*sqrt(new_table$SE^2 + (new_table$Beta_est- Modavg_beta)^2))
      }

      #revised computation of unconditional SE based on equation 6.12 of Burnham and Anderson 2002; Anderson 2008, p. 111
      if(identical(uncond.se, "revised")) {
        Uncond_SE <- sqrt(sum(new_table$AICWt*(new_table$SE^2 + (new_table$Beta_est- Modavg_beta)^2)))
      }
    }
    

    #QAIC
    #if c-hat is estimated compute values accordingly and adjust table names  
    if(c.hat > 1 && second.ord == FALSE) {
      Modavg_beta <- sum(new_table$QAICWt*new_table$Beta_est)

      #unconditional SE based on equation 4.9 of Burnham and Anderson 2002
      if(identical(uncond.se, "old")) {
        Uncond_SE <- sum(new_table$QAICWt*sqrt(new_table$SE^2 + (new_table$Beta_est- Modavg_beta)^2))
      }

      #revised computation of unconditional SE based on equation 6.12 of Burnham and Anderson 2002; Anderson 2008, p. 111
      if(identical(uncond.se, "revised")) {
        Uncond_SE <- sqrt(sum(new_table$QAICWt*(new_table$SE^2 + (new_table$Beta_est- Modavg_beta)^2)))
      } 
    }
    

    out.est[g, 1] <- Modavg_beta
    out.est[g, 2] <- Uncond_SE
  }
     
  zcrit <- qnorm(p=(1-conf.level)/2, lower.tail=FALSE)
  out.est[,3] <- out.est[,1] - zcrit*out.est[,2]
  out.est[,4] <- out.est[,1] + zcrit*out.est[,2]
  out.modavg <- list("Parameter"=paste(parm), "Mod.avg.table" = new_table, "Mod.avg.beta" = out.est[,1],
                     "Uncond.SE" = out.est[,2], "Conf.level" = conf.level, "Lower.CL"= out.est[,3],
                     "Upper.CL" = out.est[,4])

  class(out.modavg) <- c("modavg", "list")
  return(out.modavg)

}

