% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ALTopt.R
\name{pv.vdus.ic}
\alias{pv.vdus.ic}
\title{VDUS (Variance Dispersion of Use Space) plot for interval censoring.}
\usage{
pv.vdus.ic(design, t, k, nf, alpha, formula, coef, useLower = NULL,
  useUpper = NULL)
}
\arguments{
\item{design}{the data frame containing the coordinates and the number of
allocation of each design point. The design created by either
\code{\link{altopt.rc}} or \code{\link{altopt.ic}} or any design matrix
with the same form as those can be provided for this argument.}

\item{t}{the total testing time.}

\item{k}{the number of time intervals.}

\item{nf}{the number of stress factors.}

\item{alpha}{the value of the shape parameter of Weibull distribution.}

\item{formula}{the object of class formula which is the linear predictor model.}

\item{coef}{the numeric vector containing the coefficients of each term in \code{formula}.}

\item{useLower,useUpper}{the vectors containing the lower bound and upper
bound for the use region. They should be provided for VDUS plot.}
}
\value{
The "trellis" object which includes the VDUS plot
  for interval censoring.
}
\description{
\code{\link{pv.vdus.ic}} draws the VDUS plot of prediction variance
for a given design with interval censoring plan. The use region
(\code{useLower} and \code{useUpper}) should be
provided.
}
\examples{
\dontrun{
# VDUS plot of I optimal design with interval censoring.
Design <- altopt.ic("I", 100, 30, 5, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01), useLower = c(1.458, 2.859), useUpper = c(2.058, 3.459))

pv.vdus.ic(Design$opt.design.rounded, 30, 5, 2, 1,
formula = ~ x1 + x2 + x1:x2, coef = c(0, -4.086, -1.476, 0.01),
useLower = c(1.458, 2.859), useUpper = c(2.058, 3.459))
}
}
\seealso{
\code{\link{altopt.ic}}
}

