% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_7_table_5}
\alias{chapter_7_table_5}
\alias{C7T5}
\alias{Chapter_7_Table_5}
\alias{c7t5}
\title{The data used in Chapter 7, Table 5}
\format{An object of class \code{data.frame} with 30 rows and 3 columns.}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., \& Kelley, K. (forthcoming). \emph{Designing experiments and 
analyzing data: {A} model comparison perspective}. (3rd ed.). Routledge.
}
\usage{
data(chapter_7_table_5)
}
\description{
The data used in Chapter 7, Table 5
}
\details{
This table represents hypothetical data from a study investigating the effects of biofeedback and drug therapy on hypertension. We (arbitrarily) refer to the presence or absence of biofeedback as factor A and to the type of drug as factor B.

The following data is a generalization of the blood pressure data given in Table 7.1 (as there are now three, rather than two, levels of the drug factor). In addition to assessing the likelihood of there being a biofeedback or a drug main effect, the interaction is explicitly taken into consideration.
}
\section{Variables}{

\describe{
\item{score}{blood pressure}
\item{feedback}{the likelihood of there being a biofeedback or drug main effect}
\item{drug}{the level of the drug factor}}
}

\section{Synonym}{

C7T5
}

\examples{
# Load the data
data(chapter_7_table_5)

# Or, alternatively load the data as
data(C7T5)

# View the structure
str(chapter_7_table_5)

}
\references{
Maxwell, S. E., Delaney, H. D., \& Kelley, K. (forthcoming). \emph{Designing experiments and analyzing data: 
{A} model comparison perspective} (3rd ed.). Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
