% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_taxonomic_update_lookup.R
\name{create_taxonomic_update_lookup}
\alias{create_taxonomic_update_lookup}
\title{Create a lookup table to help fix the taxonomy for a list of Australian plant species}
\usage{
create_taxonomic_update_lookup(
  taxa,
  stable_or_current_data = "stable",
  version = default_version(),
  taxonomic_splits = "most_likely_species",
  full = FALSE,
  APNI_matches = TRUE,
  imprecise_fuzzy_matches = FALSE,
  identifier = NA_character_,
  resources = load_taxonomic_resources(stable_or_current_data = stable_or_current_data,
    version = version),
  output = NULL
)
}
\arguments{
\item{taxa}{A list of Australian plant species that needs to be reconciled with current taxonomy.}

\item{stable_or_current_data}{either "stable" for a consistent version, or "current" for the leading edge version.}

\item{version}{The version number of the dataset to use.}

\item{taxonomic_splits}{How to handle one_to_many taxonomic matches.  Default is "return_all".  The other options are "collapse_to_higher_taxon" and "most_likely_species". most_likely_species defaults to the original_name if that name is accepted by the APC; this will be right for certain species subsets, but make errors in other cases, use with caution.}

\item{full}{logical for whether the full lookup table is returned or just the two key columns}

\item{APNI_matches}{Name matches to the APNI (Australian Plant Names Index) are turned off as a default.}

\item{imprecise_fuzzy_matches}{Imprecise fuzzy matches are turned off as a default.}

\item{identifier}{A dataset, location or other identifier, which defaults to NA.}

\item{resources}{These are the taxonomic resources used for cleaning, this will default to loading them from a local place on your computer.  If this is to be called repeatedly, it's much faster to load the resources using \code{\link{load_taxonomic_resources}} separately and pass the data in.}

\item{output}{file path to save the intermediate output to}
}
\value{
A lookup table containing the accepted and suggested names for each original name input, and additional taxonomic information such as taxon rank, taxonomic status, taxon IDs and genera. See Details.
}
\description{
This function takes a list of Australian plant species that needs to be reconciled with current taxonomy and generates a lookup table to help fix the taxonomy. The lookup table contains the original species names, the aligned species names, and additional taxonomic information such as taxon IDs and genera.
}
\details{
\itemize{
\item original_name: the original plant name.
\item aligned_name: the input plant name that has been aligned to a taxon name in the APC or APNI by the align_taxa function.
\item accepted_name: the APC-accepted plant name, when available.
\item suggested_name: the suggested plant name to use. Identical to the accepted_name, when an accepted_name exists; otherwise the the suggested_name is the aligned_name.
\item genus: the genus of the accepted (or suggested) name; only APC-accepted genus names are filled in.
\item family: the family of the accepted (or suggested) name; only APC-accepted family names are filled in.
\item taxon_rank: the taxonomic rank of the suggested (and accepted) name.
\item taxonomic_dataset: the source of the suggested (and accepted) names (APC or APNI).
\item taxonomic_status: the taxonomic status of the suggested (and accepted) name.
\item taxonomic_status_aligned: the taxonomic status of the aligned name, before any taxonomic updates have been applied.
\item aligned_reason: the explanation of a specific taxon name alignment (from an original name to an aligned name).
\item update_reason: the explanation of a specific taxon name update (from an aligned name to an accepted or suggested name).
\item subclass: the subclass of the accepted name.
\item taxon_distribution: the distribution of the accepted name; only filled in if an APC accepted_name is available.
\item scientific_name_authorship: the authorship information for the accepted (or known) name; available for both APC and APNI names.
\item taxon_ID: the unique taxon concept identifier for the accepted_name; only filled in if an APC accepted_name is available.
\item taxon_ID_genus: an identifier for the genus; only filled in if an APC-accepted genus name is available.
\item scientific_name_ID: an identifier for the nomenclatural (not taxonomic) details of a scientific name; available for both APC and APNI names.
\item row_number: the row number of a specific original_name in the input.
\item number_of_collapsed_taxa: when taxonomic_splits == "collapse_to_higher_taxon", the number of possible taxon names that have been collapsed.
}
}
\examples{
\donttest{resources <- load_taxonomic_resources()
create_taxonomic_update_lookup(c("Eucalyptus regnans",
                                 "Acacia melanoxylon",
                                 "Banksia integrifolia",
                                 "Not a species"),
                                 resources=resources)
}
}
\seealso{
\code{\link{load_taxonomic_resources}}

Other taxonomic alignment functions: 
\code{\link{align_taxa}()},
\code{\link{update_taxonomy}()}
}
\concept{taxonomic alignment functions}
