% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/CalculateAMIds.R
\name{calculateAMids}
\alias{calculateAMids}
\title{calculateAMids}
\usage{
calculateAMids(pedtxtFile, fileReferences)
}
\arguments{
\item{pedtxtFile}{Name of the ped file to be used. The ped file should include all 51 HGDP references and the individuals for which the user wishes to calculate the genetic distance.}

\item{fileReferences}{File detailing the individuals in the ped file that correspond to the references, and the populations they refer to. A file that uses the 51 HGDP reference populations is provided with the package.}
}
\value{
returns a dataframe containing the genetic distance of each sample individual to the population references. This dataframe can be subsequently used as input to \code{plotAMids}.
}
\description{
\code{calculateAMids} returns for each individual a set of distances to a given group of population references
}
\details{
Calculates genetics distance between a sample population and population references.
}
\examples{
\dontrun{
library(AncestryMapper)
HGDP.References <- system.file('extdata', 'HGDP.References.txt', package='AncestryMapper')
HGDP.500SNPs <- system.file('extdata', 'HGDP.500SNPs.ped', package='AncestryMapper')
HGDP.Phenotypes <- system.file('extdata', 'HGDP.Phenotypes.txt', package='AncestryMapper')
genetic.distance <- calculateAMids(pedtxtFile=HGDP.500SNPs, fileReferences=HGDP.References)
}
}

