% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.beta}
\alias{kernel.beta}
\title{Beta diversity partitioning using kernel density hypervolumes.}
\usage{
kernel.beta(comm, func = "jaccard", comp = FALSE)
}
\arguments{
\item{comm}{A 'HypervolumeList' object, preferably built using function kernel.build.}

\item{func}{Partial match indicating whether the Jaccard or Soerensen family of beta diversity measures should be used.  If not specified, default is Jaccard.}

\item{comp}{Boolean indicating whether beta diversity components (shared and unique fractions) should be returned}
}
\value{
Three pairwise distance matrices, one per each of the three beta diversity components. If comp = TRUE also three distance matrices with beta diversity components.
}
\description{
Pairwise beta diversity partitioning into replacement and net difference in amplitude components of n-dimensional hypervolumes.
}
\details{
Computes a pairwise decomposition of the overall differentiation among kernel hypervolumes into two components: the replacement (shifts) of space between hypervolumes and net differences between the amount of space enclosed by each hypervolume.
The beta diversity measures used here follow the FD partitioning framework developed by Carvalho & Cardoso (2020), where Btotal = Breplacement + Brichness. Beta diversity ranges from 0 (when hypervolumes are identical) to 1 (when hypervolumes are fully dissimilar).
See Carvalho & Cardoso (2020) and Mammola & Cardoso (2020) for the full formulas of beta diversity used here.
}
\examples{
\dontrun{
comm <- rbind(c(1,1,1,1,1), c(1,1,1,1,1), c(0,0,1,1,1),c(0,0,1,1,1))
colnames(comm) = c("SpA","SpB","SpC","SpD", "SpE")
rownames(comm) = c("Site 1","Site 2","Site 3","Site 4")

trait <- cbind(c(2.2,4.4,6.1,8.3,3),c(0.5,1,0.5,0.4,4),c(0.7,1.2,0.5,0.4,5),c(0.7,2.2,0.5,0.3,6))
colnames(trait) = c("Trait 1","Trait 2","Trait 3","Trait 4")
rownames(trait) = colnames(comm)

hvlist = kernel.build(comm, trait)
kernel.beta(hvlist)
hvlist = kernel.build(comm, trait, axes = 0.9)
kernel.beta(hvlist, comp = TRUE)
}
}
\references{
Carvalho, J.C. & Cardoso, P. (2020) Decomposing the causes for niche differentiation between species using hypervolumes. Frontiers in Ecology and Evolution, 8: 243.

Mammola, S. & Cardoso, P. (2020) Functional diversity metrics using kernel density n-dimensional hypervolumes. Methods in Ecology and Evolution, 11: 986-995.
}
