% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ib.plot.R
\name{ib.plot.bcea}
\alias{ib.plot.bcea}
\alias{ib.plot}
\title{Incremental Benefit (IB) Distribution Plot}
\usage{
\method{ib.plot}{bcea}(
  he,
  comparison = NULL,
  wtp = 25000,
  bw = "bcv",
  n = 512,
  xlim = NULL,
  graph = c("base", "ggplot2"),
  ...
)

ib.plot(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{comparison}{In the case of multiple interventions, specifies the one
to be used in comparison with the reference. Default value of \code{NULL}
forces R to consider the first non-reference intervention as the comparator.
Controls which comparator is used when more than 2 interventions are present}

\item{wtp}{The value of the willingness to pay threshold. Default value at
\code{25000}.}

\item{bw}{Identifies the smoothing bandwidth used to construct the kernel
estimation of the IB density.}

\item{n}{The number of equally spaced points at which the density is to be
estimated.}

\item{xlim}{The limits of the plot on the x-axis.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-) match the two options \code{"base"} or
\code{"ggplot2"}. Default value is \code{"base"}.}

\item{...}{Additional arguments}
}
\value{
\item{ib}{ A ggplot object containing the requested plot. Returned
only if \code{graph="ggplot2"}. } The function produces a plot of the
distribution of the Incremental Benefit for a given value of the willingness
to pay parameter. The dashed area indicates the positive part of the
distribution (i.e. when the reference is more cost-effective than the
comparator).
}
\description{
Plots the distribution of the Incremental Benefit (IB) for a given value of
the willingness to pay threshold.
}
\references{
Baio, G., Dawid, A. P. (2011). Probabilistic Sensitivity
Analysis in Health Economics. Statistical Methods in Medical Research
doi:10.1177/0962280211419832.

Baio G. (2012). Bayesian Methods in Health Economics. CRC/Chapman Hall, London.
}
\seealso{
\code{\link{bcea}},
         \code{\link{ceplane.plot}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\concept{"Health economic evaluation"}
