% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{growth}
\alias{growth}
\alias{growth,Bac-method}
\title{Function implementing a growth model of a bacterium}
\usage{
growth(object, population, j)

\S4method{growth}{Bac}(object, population, j)
}
\arguments{
\item{object}{An object of class Bac.}

\item{population}{An object of class Arena.}

\item{j}{The number of the iteration of interest.}
}
\value{
Boolean variable of the \code{j}th individual indicating if individual died.
}
\description{
The generic function \code{growth} implements different growth models for an object of class Bac.
}
\details{
Linear growth of organisms is implemented by adding the calculated growthrate by \code{optimizeLP} to the already present growth value. Exponential growth of organisms is implemented by adding the calculated growthrate multiplied with the current growth calculated by \code{optimizeLP} plus to the already present growth value
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           growthlimit=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
addOrg(arena,bac,amount=10) #add 10 organisms
addSubs(arena,40) #add all possible substances
growth(bac,arena,1)
}
\seealso{
\code{\link{Bac-class}}, \code{\link{growLin}} and \code{\link{growExp}}
}

