% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{statPheno}
\alias{statPheno}
\alias{statPheno,Eval-method}
\title{Function for investigating a specific phenotype of an organism}
\usage{
statPheno(object, type_nr = 1, phenotype_nr, dict = NULL)

\S4method{statPheno}{Eval}(object, type_nr = 1, phenotype_nr,
  dict = NULL)
}
\arguments{
\item{object}{An object of class Eval.}

\item{type_nr}{A number indicating the Organism type of the phenotype to be investigated (from orgdat)}

\item{phenotype_nr}{A number indicating the phenotype to be investigated (from orgdat)}

\item{dict}{A character vector of all substance IDs with names that should be used instead of possibly cryptic IDs}
}
\description{
The generic function \code{statPheno} provides statistical and visual information about a certain phenotype.
}
\details{
The phenotypes are defined by flux through exchange reactions, which indicate potential differential substrate usages.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
statPheno(eval, type_nr=1, phenotype_nr=2)
}
\seealso{
\code{\link{Eval-class}}
}
