% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.ref.R
\name{sample.ref}
\alias{sample.ref}
\title{Sample Random Datasets from References (DNAbin)}
\usage{
sample.ref(ref, sample.porp = 0.5, sample.level = "full")
}
\arguments{
\item{ref}{Object of class "DNAbin" used as a reference dataset, which contains taxon information.}

\item{sample.porp}{a numeric value between 0 and 1, indicating proportion of samples to draw 
at each level of taxon.}

\item{sample.level}{a character string choosing from c("full","family","genus","species").}
}
\value{
a list containing the selected samples and the samples left, in DNAbin format stored in a matrix or a list.
}
\description{
Randomly sample reference data at different levels of taxon.
}
\note{
the ref must contain information on taxonomy, in format like, ">LS0909030M,Noctuidae_Himalaea_unica",
i.e., "seqID,family_genus_species", or ">LS0909030M,Himalaea_unica"; in case there is only one sample/individual
for a taxon level, this sample will be retained in ref.selected.
}
\examples{

data(TibetanMoth) 
data(pineMothITS2)
ref<-TibetanMoth
ref2<-pineMothITS2
out<-sample.ref(ref,sample.porp=0.5,sample.level="full")
out
out2<-sample.ref(ref2,sample.porp=0.5,sample.level="full")
out2


}
\author{
Ai-bing ZHANG, PhD. CNU, Beijing, CHINA.
}
\references{
zhangab2008(at)mail.cnu.edu.cn;
}
\keyword{sample.ref}

